/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.tcp.TcpIoStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class BinaryProtocolServer {
    private static final int PROXY_PORT = 2390;
    private static final String TS_OK = "\u0000";
    private static final String TS_SIGNATURE = "MShift v0.01";
    private static final String TS_PROTOCOL = "001";

    public static void start() {
        FileLog.MAIN.logLine("BinaryProtocolServer on 2390");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(2390, 1);
                    while (true) {
                        final Socket clientSocket = serverSocket.accept();
                        FileLog.MAIN.logLine("Binary protocol proxy port connection");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    BinaryProtocolServer.runProxy(clientSocket);
                                }
                                catch (IOException e) {
                                    FileLog.MAIN.logLine("proxy connection: " + e);
                                }
                            }
                        }, "proxy connection").start();
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        new Thread(runnable, "BinaryProtocolServer").start();
    }

    private static void runProxy(Socket clientSocket) throws IOException {
        DataInputStream in = new DataInputStream(clientSocket.getInputStream());
        while (true) {
            BinaryProtocol bp;
            short count;
            byte first;
            if ((first = in.readByte()) == 70) {
                System.out.println("Got plain F command");
                OutputStream outputStream = clientSocket.getOutputStream();
                outputStream.write(TS_PROTOCOL.getBytes());
                outputStream.flush();
                continue;
            }
            int length = first * 256 + in.readByte();
            System.out.println("Got [" + length + "] length promise");
            if (length == 0) {
                throw new IOException("Zero length not expected");
            }
            byte[] packet = new byte[length];
            in.read(packet);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet));
            byte command = (byte)dis.read();
            System.out.println("Got [" + (char)command + "/" + command + "] command");
            int crc = in.readInt();
            if (crc != IoHelper.getCrc32(packet)) {
                throw new IllegalStateException("CRC mismatch");
            }
            TcpIoStream stream = new TcpIoStream(clientSocket.getInputStream(), clientSocket.getOutputStream());
            if (command == 83) {
                BinaryProtocol.sendCrcPacket("\u0000MShift v0.01".getBytes(), FileLog.LOGGER, stream);
                continue;
            }
            if (command == 70) {
                BinaryProtocol.sendCrcPacket("\u0000001".getBytes(), FileLog.LOGGER, stream);
                continue;
            }
            if (command == 107) {
                short page = dis.readShort();
                short offset = dis.readShort();
                count = dis.readShort();
                System.out.println("CRC check " + page + "/" + offset + "/" + count);
                bp = BinaryProtocol.instance;
                int result = IoHelper.getCrc32(bp.getController().getContent(), offset, count);
                ByteArrayOutputStream response = new ByteArrayOutputStream();
                response.write(TS_OK.charAt(0));
                new DataOutputStream(response).write(result);
                BinaryProtocol.sendCrcPacket(response.toByteArray(), FileLog.LOGGER, stream);
                continue;
            }
            if (command == 80) {
                BinaryProtocol.sendCrcPacket(TS_OK.getBytes(), FileLog.LOGGER, stream);
                continue;
            }
            if (command == 82) {
                short page = dis.readShort();
                short offset = BinaryProtocolServer.swap16(dis.readShort());
                count = BinaryProtocolServer.swap16(dis.readShort());
                if (count <= 0) {
                    FileLog.MAIN.logLine("Error: negative read request " + offset + "/" + count);
                    continue;
                }
                System.out.println("read " + page + "/" + offset + "/" + count);
                bp = BinaryProtocol.instance;
                byte[] response = new byte[1 + count];
                response[0] = (byte)TS_OK.charAt(0);
                System.arraycopy(bp.getController().getContent(), offset, response, 1, count);
                BinaryProtocol.sendCrcPacket(response, FileLog.LOGGER, stream);
                continue;
            }
            if (command == 79) {
                byte[] response = new byte[277];
                response[0] = (byte)TS_OK.charAt(0);
                byte[] currentOutputs = BinaryProtocol.currentOutputs;
                if (currentOutputs != null) {
                    System.arraycopy(currentOutputs, 1, response, 1, 276);
                }
                BinaryProtocol.sendCrcPacket(response, FileLog.LOGGER, stream);
                continue;
            }
            FileLog.MAIN.logLine("Error: unknown command " + command);
        }
    }

    private static short swap16(short x) {
        return (short)(x << 8 | x >> 8);
    }
}

