/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.ResponseBuffer;
import com.rusefi.io.DataListener;
import com.rusefi.io.LinkConnector;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpIoStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;

public class TcpConnector
implements LinkConnector {
    public static final int DEFAULT_PORT = 29001;
    public static final String LOCALHOST = "localhost";
    private final int port;
    private final String hostname;
    private BinaryProtocol bp;

    public TcpConnector(String port) {
        try {
            this.port = TcpConnector.getTcpPort(port);
            this.hostname = TcpConnector.getHostname(port);
        }
        catch (InvalidTcpPort e) {
            throw new IllegalStateException("Unexpected", e);
        }
    }

    public static boolean isTcpPort(String port) {
        try {
            TcpConnector.getTcpPort(port);
            return true;
        }
        catch (InvalidTcpPort e) {
            return false;
        }
    }

    public static int getTcpPort(String port) throws InvalidTcpPort {
        try {
            String[] portParts = port.split(":");
            int index = portParts.length == 1 ? 0 : 1;
            return Integer.parseInt(portParts[index]);
        }
        catch (NumberFormatException e) {
            throw new InvalidTcpPort();
        }
    }

    private static String getHostname(String port) {
        String[] portParts = port.split(":");
        return portParts.length == 1 ? LOCALHOST : (portParts[0].length() > 0 ? portParts[0] : LOCALHOST);
    }

    @Override
    public void connect(LinkManager.LinkStateListener listener) {
        BufferedInputStream stream;
        OutputStream os;
        FileLog.MAIN.logLine("Connecting to host=" + this.hostname + "/port=" + this.port);
        try {
            Socket socket = new Socket(this.hostname, this.port);
            os = socket.getOutputStream();
            stream = new BufferedInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to connect to simulator: " + this.hostname + "/" + this.port, e);
        }
        final ResponseBuffer rb = new ResponseBuffer(new ResponseBuffer.ResponseListener(){

            @Override
            public void onResponse(String line) {
                LinkManager.engineState.processNewData(line + "\r\n", LinkManager.ENCODER);
            }
        });
        DataListener listener1 = new DataListener(){

            @Override
            public void onDataArrived(byte[] freshData) {
                rb.append(new String(freshData), LinkManager.ENCODER);
            }
        };
        this.bp = new BinaryProtocol(FileLog.LOGGER, new TcpIoStream(stream, os));
        boolean result = this.bp.connectAndReadConfiguration(listener1);
        if (result) {
            listener.onConnectionEstablished();
        } else {
            listener.onConnectionFailed();
        }
    }

    @Override
    public void restart() {
    }

    @Override
    public boolean hasError() {
        return false;
    }

    @Override
    public String unpack(String packet) {
        return packet;
    }

    @Override
    public void send(String command, boolean fireEvent) throws InterruptedException {
        this.bp.doSend(command, fireEvent);
    }

    @Override
    public String unpackConfirmation(String message) {
        if (message.startsWith("confirmation_")) {
            return message.substring("confirmation_".length());
        }
        return null;
    }

    public static Collection<String> getAvailablePorts() {
        return TcpConnector.isTcpPortOpened() ? Collections.singletonList("29001") : Collections.emptyList();
    }

    public static boolean isTcpPortOpened() {
        try {
            Socket s = new Socket(LOCALHOST, 29001);
            s.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Connection refused in getAvailablePorts(): simulator not running");
            return false;
        }
    }

    static class InvalidTcpPort
    extends Exception {
        InvalidTcpPort() {
        }
    }
}

