/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.maintenance.ProcessStatusWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class FirmwareFlasher
extends ProcessStatusWindow {
    public static final String IMAGE_DEBUG_FILE = "rusefi_debug.bin";
    public static final String IMAGE_RELEASE_FILE = "rusefi_release.bin";
    static final String OPENOCD_BIN = "openocd/bin/openocd-0.8.0.exe";
    private static final String SUCCESS_MESSAGE_TAG = "shutdown command invoked";
    private static final String FAILED_MESSAGE_TAG = "failed";
    private static final String NO_DRIVER_MESSAGE_TAG = "failed with LIBUSB_ERROR_NOT_SUPPORTED";
    private final JButton button;
    private String fileName;

    public FirmwareFlasher(String fileName, String buttonTest) {
        this.fileName = fileName;
        this.button = new JButton(buttonTest);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int dialogResult = JOptionPane.showConfirmDialog(FirmwareFlasher.this.button, "Do you really want to update firmware? Please disconnect vehicle battery before erasing.", "Please disconnect from vehicle", 0);
                if (dialogResult != 0) {
                    return;
                }
                FirmwareFlasher.this.wnd.showFrame("rusEfi Firmware Flasher");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FirmwareFlasher.this.doFlashFirmware();
                    }
                };
                FirmwareFlasher.this.submitAction(runnable);
            }
        });
    }

    private void doFlashFirmware() {
        if (!new File(this.fileName).exists()) {
            this.wnd.appendMsg(this.fileName + " not found, cannot proceed !!!");
            return;
        }
        StringBuffer error = this.executeCommand("openocd/bin/openocd-0.8.0.exe -f interface/stlink-v2.cfg -f board/stm32f4discovery.cfg -c \"program " + this.fileName + " verify reset exit 0x08000000\"");
        if (error.toString().contains(NO_DRIVER_MESSAGE_TAG)) {
            this.wnd.appendMsg(" !!! ERROR: looks like stm32 driver is not installed? The link is above !!!");
        } else if (error.toString().contains(SUCCESS_MESSAGE_TAG) && !error.toString().contains(FAILED_MESSAGE_TAG)) {
            this.wnd.appendMsg("!!! Looks good!!!");
        } else {
            this.wnd.appendMsg("!!! FIRMWARE FLASH: DOES NOT LOOK RIGHT !!!");
        }
    }

    public JButton getButton() {
        return this.button;
    }
}

