/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.ui.StatusWindow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessStatusWindow {
    protected final StatusWindow wnd = new StatusWindow();

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    protected static boolean isRunning(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected void startStreamThread(final Process p, final InputStream stream, final StringBuffer buffer) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    BufferedReader bis = new BufferedReader(new InputStreamReader(stream));
                    while (ProcessStatusWindow.isRunning(p) && (line = bis.readLine()) != null) {
                        ProcessStatusWindow.this.wnd.appendMsg(line);
                        buffer.append(line);
                    }
                }
                catch (IOException e) {
                    ProcessStatusWindow.this.wnd.appendMsg("Stream " + e);
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    protected StringBuffer executeCommand(String command) {
        this.wnd.appendMsg("Executing " + command);
        StringBuffer output = new StringBuffer();
        StringBuffer error = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec(command);
            this.startStreamThread(p, p.getInputStream(), output);
            this.startStreamThread(p, p.getErrorStream(), error);
            p.waitFor();
        }
        catch (IOException e) {
            this.wnd.appendMsg("IOError: " + e);
        }
        catch (InterruptedException e) {
            this.wnd.appendMsg("WaitError: " + e);
        }
        return error;
    }

    protected void submitAction(Runnable runnable) {
        Thread thread = new Thread(runnable, "console extProcessThread");
        thread.setDaemon(true);
        thread.start();
    }
}

