/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models;

import com.rusefi.FileLog;
import com.rusefi.models.Point3D;
import com.rusefi.models.XYData;
import com.rusefi.models.YAxisData;
import java.util.Iterator;
import java.util.SortedSet;

public class AverageData {
    public static XYData average(XYData data, int divider) {
        double minX = data.getMinXValue();
        double xWidth = data.getMaxXValue() - minX;
        FileLog.MAIN.logLine("From x" + minX + " w=" + xWidth);
        XYData result = new XYData();
        for (int i = 0; i < divider; ++i) {
            double fromX_ = minX + xWidth * (double)i / (double)divider;
            double toX_ = minX + xWidth * (double)(i + 1) / (double)divider;
            FileLog.MAIN.logLine("from " + fromX_ + " to " + toX_);
            AverageData.average(data, result, fromX_, toX_, divider);
        }
        return result;
    }

    private static void average(XYData data, XYData result, double fromX, double toX, int divider) {
        double minY = data.getMinYValue();
        double yWidth = data.getMaxYValue() - minY;
        for (int i = 0; i < divider; ++i) {
            double fromY_ = minY + yWidth * (double)i / (double)divider;
            double toY_ = minY + yWidth * (double)(i + 1) / (double)divider;
            SortedSet<Double> xRange = data.getXSet().tailSet(fromX).headSet(toX);
            int counter = 0;
            double acc = 0.0;
            for (Double x : xRange) {
                YAxisData yData = data.getYAxis(x);
                SortedSet<Double> yRange = yData.getYs().tailSet(fromY_).headSet(toY_);
                Iterator iterator = yRange.iterator();
                while (iterator.hasNext()) {
                    double y = (Double)iterator.next();
                    ++counter;
                    acc += yData.getValue(y);
                }
            }
            if (counter == 0) {
                result.addPoint(new Point3D(fromX, fromY_, Float.NaN));
                continue;
            }
            result.addPoint(new Point3D(fromX, fromY_, (float)(acc / (double)counter)));
        }
    }
}

