/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models;

import com.rusefi.models.Factory;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Utils {
    private static final int LARGE_VALUE = 10000000;

    public static int findClosest(TreeMap<Integer, ?> map, int value) {
        NavigableMap<Integer, ?> head = map.headMap(value, true);
        NavigableMap<Integer, ?> tail = map.tailMap(value, true);
        if (head.isEmpty() && tail.isEmpty()) {
            throw new IllegalStateException("Empty map? " + value);
        }
        int fromHead = head.isEmpty() ? 10000000 : (Integer)head.lastKey();
        int fromTail = tail.isEmpty() ? 10000000 : (Integer)tail.firstKey();
        int headDiff = Math.abs(value - fromHead);
        int tailDiff = Math.abs(value - fromTail);
        return headDiff < tailDiff ? fromHead : fromTail;
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Factory<K, V> factory) {
        V result = map.get(key);
        if (result != null) {
            return result;
        }
        result = factory.create(key);
        map.put(key, result);
        return result;
    }

    public static int parseIntWithReason(String number, String reason) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unexpected [" + number + "] for " + reason, e);
        }
    }
}

