/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models;

import com.rusefi.FileLog;
import com.rusefi.models.Point3D;
import com.rusefi.models.XYData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class XYDataReader {
    public static XYData readFile(String fileName) {
        if (!new File(fileName).exists()) {
            throw new IllegalArgumentException("No file: " + fileName);
        }
        try {
            return XYDataReader.doReadFile(fileName);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static XYData doReadFile(String fileName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        XYData data = new XYData();
        while ((line = reader.readLine()) != null) {
            Point3D xyz = Point3D.parseLine(line);
            data.addPoint(xyz);
        }
        FileLog.MAIN.logLine("x range: " + data.getMinXValue() + " to " + data.getMaxXValue());
        FileLog.MAIN.logLine("y range: " + data.getMinYValue() + " to " + data.getMaxYValue());
        return data;
    }
}

