/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.trigger;

import com.rusefi.TriggerImage;
import com.rusefi.waves.EngineReport;
import java.util.ArrayList;
import java.util.List;

public class WaveState {
    double unusedDown = Double.NaN;
    double prevUp = Double.NaN;
    public List<EngineReport.UpDown> list = new ArrayList<EngineReport.UpDown>();

    public void handle(trigger_value_e signal, double angle) {
        if (signal == trigger_value_e.TV_LOW) {
            if (Double.isNaN(this.prevUp)) {
                this.unusedDown = angle;
            } else {
                EngineReport.UpDown ud = new EngineReport.UpDown(TriggerImage.angleToTime(this.prevUp), 0, TriggerImage.angleToTime(angle), 0);
                this.list.add(ud);
            }
            this.prevUp = Double.NaN;
        } else {
            this.prevUp = angle;
        }
    }

    public void wrap() {
        if (!Double.isNaN(this.unusedDown)) {
            this.list.add(0, new EngineReport.UpDown(TriggerImage.angleToTime(this.prevUp), 0, TriggerImage.angleToTime(this.unusedDown + (double)(720 * (3 + TriggerImage.EXTRA_COUNT))), 0));
        }
    }

    public int getMaxTime() {
        if (this.list.isEmpty()) {
            return 0;
        }
        return this.list.get((int)(this.list.size() - 1)).downTime;
    }

    public static enum trigger_value_e {
        TV_LOW,
        TV_HIGH;

    }
}

