/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.FileLog;
import com.rusefi.models.Range;
import com.rusefi.models.Utils;
import com.rusefi.models.XYData;
import com.rusefi.ui.util.JTextFieldWithWidth;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.ericaro.surfaceplotter.DefaultSurfaceModel;
import net.ericaro.surfaceplotter.JSurfacePanel;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.surface.SurfaceModel;

public class ChartHelper {
    private ChartHelper() {
    }

    public static JPanel create3DControl(final XYData data, SurfaceModel surfaceModel, String title) {
        final JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createLineBorder(Color.red));
        final JSurfacePanel jsp = new JSurfacePanel(surfaceModel);
        jsp.setTitleText(title);
        jsp.setConfigurationVisible(true);
        jsp.getSurface().setXLabel("RPM");
        jsp.getSurface().setYLabel("MAF voltage");
        result.add("Center", jsp);
        JButton saveImageButton = UiUtils.createSaveImageButton();
        saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = FileLog.getDate() + "_3d.png";
                UiUtils.saveImageWithPrompt(fileName, result, jsp);
            }
        });
        JPanel upperPanel = new JPanel(new FlowLayout());
        upperPanel.add(saveImageButton);
        result.add((Component)upperPanel, "North");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(new JLabel("RPM: "));
        final JTextFieldWithWidth xField = new JTextFieldWithWidth("1200", 150);
        final JTextFieldWithWidth yField = new JTextFieldWithWidth("50", 150);
        bottomPanel.add(xField);
        bottomPanel.add(yField);
        final JLabel currentValue = new JLabel();
        bottomPanel.add(currentValue);
        result.add((Component)bottomPanel, "South");
        ActionListener updateValue = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rpm = Utils.parseIntWithReason(xField.getText(), "CH xField");
                double y = Double.parseDouble(yField.getText());
                currentValue.setText("" + data.getValue(rpm, y));
            }
        };
        xField.addActionListener(updateValue);
        yField.addActionListener(updateValue);
        updateValue.actionPerformed(null);
        return result;
    }

    public static DefaultSurfaceModel createDefaultSurfaceModel(XYData data) {
        return ChartHelper.createDefaultSurfaceModel(data, null);
    }

    public static DefaultSurfaceModel createDefaultSurfaceModel(XYData data, XYData data2) {
        Range xRange = new Range((float)data.getMinXValue(), (float)data.getMaxXValue());
        Range yRange = new Range((float)data.getMinYValue(), (float)data.getMaxYValue());
        return ChartHelper.createDefaultSurfaceModel(data, xRange, yRange, data2);
    }

    public static DefaultSurfaceModel createDefaultSurfaceModel(XYData data, Range xRange, Range yRange) {
        return ChartHelper.createDefaultSurfaceModel(data, xRange, yRange, null);
    }

    public static DefaultSurfaceModel createDefaultSurfaceModel(final XYData data, Range xRange, Range yRange, final XYData data2) {
        DefaultSurfaceModel sm = new DefaultSurfaceModel();
        sm.setPlotFunction2(false);
        sm.setCalcDivisions(50);
        sm.setDispDivisions(50);
        sm.setContourLines(10);
        sm.setXMin(xRange.getMin());
        sm.setXMax(xRange.getMax());
        ChartHelper.setYRange(yRange, sm);
        sm.setBoxed(true);
        sm.setDisplayXY(true);
        sm.setExpectDelay(false);
        sm.setAutoScaleZ(true);
        sm.setDisplayZ(true);
        sm.setMesh(true);
        sm.setPlotType(SurfaceModel.PlotType.SURFACE);
        if (data2 == null) {
            sm.setFirstFunctionOnly(true);
        } else {
            sm.setBothFunction(true);
        }
        sm.setPlotColor(data2 != null ? SurfaceModel.PlotColor.FOG : SurfaceModel.PlotColor.SPECTRUM);
        sm.setMapper(new Mapper(){

            @Override
            public float f1(float x, float y) {
                return data.getValue(x, y);
            }

            @Override
            public float f2(float x, float y) {
                if (data2 == null) {
                    return 0.0f;
                }
                return data2.getValue(x, y);
            }
        });
        sm.plot().execute();
        return sm;
    }

    public static void setYRange(Range yRange, DefaultSurfaceModel sm) {
        sm.setYMin(yRange.getMin());
        sm.setYMax(yRange.getMax());
    }
}

