/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.KeyStrokeShortcut;
import com.rusefi.ui.ChartRepository;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ChartScrollControl {
    private final JPanel content = new JPanel(new FlowLayout(2, 5, 0));
    private final AtomicInteger index = new AtomicInteger();
    private static final JLabel info = new JLabel();
    private ChartRepository.ChartRepositoryListener listener;

    public ChartScrollControl(ChartRepository.ChartRepositoryListener listener) {
        this.listener = listener;
        this.content.setBorder(BorderFactory.createLineBorder(Color.red));
        this.setInfoText(this.index);
        JButton prev = new JButton("<");
        prev.setToolTipText("Previous page");
        prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartScrollControl.this.previousPage();
            }
        });
        JButton next = new JButton(">");
        next.setToolTipText("Next page");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartScrollControl.this.nextPage();
            }
        });
        this.content.add(prev);
        this.content.add(info);
        this.content.add(next);
        this.bindKeyStrokeActions();
    }

    private void previousPage() {
        if (ChartRepository.getInstance().getSize() < this.index.get()) {
            this.index.set(0);
        }
        if (ChartRepository.getInstance().getSize() == 0) {
            return;
        }
        if (this.index.intValue() > 0) {
            this.index.decrementAndGet();
            this.showChart();
        } else if (this.index.intValue() == 0) {
            this.index.set(ChartRepository.getInstance().getSize() - 1);
            this.showChart();
        }
    }

    private void showChart() {
        this.listener.onDigitalChart(ChartRepository.getInstance().getChart(this.index.get()));
        this.setInfoText(this.index);
    }

    private void nextPage() {
        if (this.index.intValue() < ChartRepository.getInstance().getSize() - 1) {
            this.index.incrementAndGet();
            this.showChart();
        }
    }

    private void bindKeyStrokeActions() {
        InputMap inputMap = this.content.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), (Object)KeyStrokeShortcut.PREVIOUS_PAGE);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), (Object)KeyStrokeShortcut.NEXT_PAGE);
        this.content.getActionMap().put((Object)KeyStrokeShortcut.PREVIOUS_PAGE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChartScrollControl.this.previousPage();
            }
        });
        this.content.getActionMap().put((Object)KeyStrokeShortcut.NEXT_PAGE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChartScrollControl.this.nextPage();
            }
        });
    }

    public JPanel getContent() {
        return this.content;
    }

    private void setInfoText(AtomicInteger index) {
        info.setText(index.get() + "/" + ChartRepository.getInstance().getSize());
    }

    public void reset() {
        this.index.set(0);
        this.setInfoText(this.index);
    }
}

