/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.ConfigurationImage;
import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.Fields;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.config.ConfigField;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class FormulasPane {
    private final JPanel content = new JPanel(new BorderLayout());
    private final JPanel centerProxy = new JPanel(new BorderLayout());
    private final String newLine = "\r\n \\\\ ";
    private boolean isPaused;

    public FormulasPane() {
        this.content.add((Component)this.centerProxy, "Center");
        this.centerProxy.add((Component)new JLabel("Waiting for data..."), "Center");
        JButton saveImage = UiUtils.createSaveImageButton();
        saveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = FileLog.getDate() + "_formulas.png";
                UiUtils.saveImageWithPrompt(fileName, FormulasPane.this.centerProxy, FormulasPane.this.centerProxy);
            }
        });
        final JButton pauseButton = UiUtils.createPauseButton();
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulasPane.this.isPaused = !FormulasPane.this.isPaused;
                UiUtils.setPauseButtonText(pauseButton, FormulasPane.this.isPaused);
            }
        });
        JPanel top = new JPanel(new FlowLayout());
        top.add(saveImage);
        top.add(pauseButton);
        this.content.add((Component)top, "North");
        this.updateFormula();
        new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FormulasPane.this.isPaused) {
                    FormulasPane.this.updateFormula();
                }
            }
        }).start();
    }

    private void updateFormula() {
        String page;
        engine_load_mode_e[] values;
        BinaryProtocol bp = BinaryProtocol.instance;
        if (bp == null) {
            return;
        }
        ConfigurationImage ci = bp.getController();
        if (ci == null) {
            return;
        }
        int algorithm = ConfigField.getIntValue(ci, Fields.FUELALGORITHM);
        if (algorithm >= (values = engine_load_mode_e.values()).length) {
            throw new IllegalStateException("Unexpected " + algorithm);
        }
        engine_load_mode_e algo = values[algorithm];
        String acceleration = this.getAccelerationVariables(ci);
        if (algo == engine_load_mode_e.LM_SPEED_DENSITY) {
            page = this.getSpeedDensity(ci, acceleration);
        } else if (algo == engine_load_mode_e.LM_PLAIN_MAF) {
            double rpm = SensorCentral.getInstance().getValue(Sensor.RPM);
            double maf = SensorCentral.getInstance().getValue(Sensor.MAF);
            String baseFuelStr = this.twoDecimals(Sensor.FUEL_BASE);
            String baseFuel = "$Base_Fuel (ms) = lookup ((RPM = " + rpm + ", MAF = " + maf + ") = " + baseFuelStr + "ms";
            String actualLastInjection = this.twoDecimals(Sensor.actualLastInjection);
            String injTime = "$Fuel (ms) = " + baseFuel + this.getInjecctorLag() + " = " + actualLastInjection + "ms_per_injection$";
            page = acceleration + injTime;
        } else {
            page = acceleration + "todo";
        }
        TeXFormula formula = new TeXFormula("\r\n" + algo.title + "\r\n \\\\ " + "\r\n \\\\ " + "\r\n \\\\ " + page + "");
        TeXIcon icon = formula.createTeXIcon(0, 20.0f);
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        JLabel label = new JLabel(icon);
        this.centerProxy.removeAll();
        this.centerProxy.add((Component)label, "Center");
    }

    @NotNull
    private String getAccelerationVariables(ConfigurationImage ci) {
        String tpsDelta = this.twoDecimals(Sensor.deltaTps);
        String elDelta = this.twoDecimals(Sensor.engineLoadAccelDelta);
        int tpsEnrichLength = ConfigField.getIntValue(ci, Fields.TPSACCELLENGTH);
        int elEnrichLength = ConfigField.getIntValue(ci, Fields.ENGINELOADACCELLENGTH);
        String tpsEnrichDelta = "$deltaTps = max(currentTps - previousTps, length = " + tpsEnrichLength + ") = " + tpsDelta + "$";
        double tpsAccelThreshold = ConfigField.getFloatValue(ci, Fields.TPSACCELENRICHMENTTHRESHOLD);
        String tpsAccelMult = "fixme";
        String tpsAccelValue = this.twoDecimals(Sensor.tpsAccelFuel);
        double tpsDecelThreshold = ConfigField.getFloatValue(ci, Fields.TPSDECELENLEANMENTTHRESHOLD);
        double tpsDecelMult = ConfigField.getFloatValue(ci, Fields.TPSDECELENLEANMENTMULTIPLIER);
        String tpsEnrich = "$tpsAccelEnrich = if ((tpsDelta = " + tpsDelta + ") > (tpsThreshold = " + tpsAccelThreshold + "), tpsDelta, 0) * (tpsAccelMultiplier = " + tpsAccelMult + ") = " + tpsAccelValue + "$";
        String loadEnrichDelta = "$deltaLoad = max(currentLoad - previousLoad, length = " + elEnrichLength + ") = " + elDelta + "$";
        return tpsEnrichDelta + "\r\n \\\\ " + tpsEnrich + "\r\n \\\\ " + loadEnrichDelta + "\r\n \\\\ ";
    }

    @NotNull
    private String getSpeedDensity(ConfigurationImage ci, String acceleration) {
        String IAT = this.oneDecimal(Sensor.IAT);
        String MAP = this.oneDecimal(Sensor.MAP);
        String T_CHARGE = this.oneDecimal(Sensor.T_CHARGE);
        double rpm = SensorCentral.getInstance().getValue(Sensor.RPM);
        String RPM = "" + (int)rpm;
        String VE = this.twoDecimals(Sensor.CURRENT_VE);
        String TARGET_AFR = this.twoDecimals(Sensor.TARGET_AFR);
        String tpsStr = this.oneDecimal(Sensor.TPS);
        String chargeAirMass = String.format("%.3fgm", SensorCentral.getInstance().getValue(Sensor.CHARGE_AIR_MASS));
        double displacement = ConfigField.getFloatValue(ci, Fields.DISPLACEMENT);
        int cylinderCount = ConfigField.getIntValue(ci, Fields.CYLINDERSCOUNT);
        String cylinderDisplacement = this.oneDecimal(displacement / (double)cylinderCount);
        String injectorFlow = this.oneDecimal(((Float)ConfigField.getValue(ci, Fields.INJECTOR_FLOW)).floatValue());
        String tCharge = "$Tcharge=f(CLT=" + this.oneDecimal(Sensor.CLT) + "C,IAT=" + IAT + "C,TPS=" + tpsStr + "\\%, RPM = " + RPM + ")=" + T_CHARGE + "C$";
        String rpm_map = "RPM=" + RPM + ",MAP=" + MAP + "kPa";
        String mCharge = "$Airmass (g/cyl) =\\frac{(V_Cylinder = " + cylinderDisplacement + "L) * (VE(" + rpm_map + ")  = " + VE + "\\%) * (MAP = " + MAP + "Kpa)}{(GAS_R = 0.28705) * ((Tcharge = " + T_CHARGE + "C) + 273.15)} = " + chargeAirMass + "$";
        String baseFuelStr = this.twoDecimals(Sensor.FUEL_BASE);
        String baseFuel = "$Base_Fuel (ms) = \\frac{($Airmass = " + chargeAirMass + ")}{(TargetAFR (" + rpm_map + ") = " + TARGET_AFR + ") * (injectorFlow = " + injectorFlow + " cc/min)} = " + baseFuelStr + "ms$";
        String IATcorr = this.twoDecimals(Sensor.iatCorrection);
        String CLTcorr = this.twoDecimals(Sensor.cltCorrection);
        String tpsAccel = this.twoDecimals(Sensor.tpsAccelFuel);
        String tempCorrections = " * cltCorr(" + CLTcorr + ") * iatCorr(" + IATcorr + ")";
        String actualLastInjection = this.twoDecimals(Sensor.actualLastInjection);
        String injTime = "$Fuel (ms) = (Base_Fuel (" + baseFuelStr + "ms) + Tps_Accel_Corr = (" + tpsAccel + "ms))" + tempCorrections + this.getInjecctorLag() + " = " + actualLastInjection + "ms_per_injection$";
        return acceleration + tCharge + "\r\n \\\\ " + mCharge + "\r\n \\\\ " + baseFuel + "\r\n \\\\ " + injTime + "\r\n \\\\ ";
    }

    @NotNull
    private String getInjecctorLag() {
        String vBatt = this.twoDecimals(Sensor.VBATT);
        return "+ ( injectorLag(VBatt = " + vBatt + ") = " + this.twoDecimals(Sensor.injectorLagMs) + ")";
    }

    private String oneDecimal(Sensor sensor) {
        return this.oneDecimal(SensorCentral.getInstance().getValue(sensor));
    }

    private String twoDecimals(Sensor sensor) {
        return this.twoDecimals(SensorCentral.getInstance().getValue(sensor));
    }

    private String oneDecimal(double ve) {
        return String.format("%.1f", ve);
    }

    private String twoDecimals(double ve) {
        return String.format("%.2f", ve);
    }

    public JPanel getContent() {
        return this.content;
    }

    static enum engine_load_mode_e {
        LM_PLAIN_MAF("Plain MAF"),
        LM_ALPHA_N("Alpha-N/TPS"),
        LM_MAP("Plain MAP"),
        LM_SPEED_DENSITY("Speed Density/MAP"),
        LM_REAL_MAF("MAF");

        private final String title;

        private engine_load_mode_e(String title) {
            this.title = title;
        }
    }
}

