/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table3D;
import com.romraider.xml.RomAttributeParser;
import com.rusefi.BinarySearch;
import com.rusefi.ConfigurationImage;
import com.rusefi.FileLog;
import com.rusefi.UploadChanges;
import com.rusefi.autotune.FuelAutoTune;
import com.rusefi.autotune.Result;
import com.rusefi.autotune.stDataOnline;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.Fields;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.GaugesGrid;
import com.rusefi.ui.GaugesGridElement;
import com.rusefi.ui.config.BaseConfigField;
import com.rusefi.ui.storage.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FuelTunePane {
    private final JPanel content = new JPanel(new BorderLayout());
    private static final int veLoadOffset = Fields.VETABLE.getOffset() + 1024;
    private static final int veRpmOffset = Fields.VETABLE.getOffset() + 1024 + 64;
    private final List<FuelDataPoint> incomingDataPoints = new ArrayList<FuelDataPoint>();
    private final float[] veLoadBins = new float[16];
    private final float[] veRpmBins = new float[16];
    private final Table3D veTable = new Table3D();
    private final Table3D changeMap = new Table3D();
    private final JButton upload = new JButton("Upload");
    private final JCheckBox collect = new JCheckBox("enable");
    private final JButton clean = new JButton("clear");
    private byte[] newVeMap;
    private DataOutputStream dos;

    public FuelTunePane(Node config) {
        final JLabel incomingBufferSize = new JLabel();
        JButton runLogic = new JButton("one iteration");
        runLogic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FuelTunePane.this.doJob();
            }
        });
        this.upload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FuelTunePane.this.uploadCurrentResukt();
            }
        });
        this.clean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FuelTunePane.this.doClean();
            }
        });
        this.collect.setSelected(false);
        JPanel topPanel = new JPanel(new FlowLayout());
        topPanel.add(this.collect);
        topPanel.add(this.clean);
        topPanel.add(incomingBufferSize);
        topPanel.add(runLogic);
        topPanel.add(this.upload);
        Timer runTime = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean runJob;
                List list = FuelTunePane.this.incomingDataPoints;
                synchronized (list) {
                    runJob = FuelTunePane.this.incomingDataPoints.size() > 50;
                }
                if (runJob) {
                    FuelTunePane.this.doJob();
                    FuelTunePane.this.uploadCurrentResukt();
                }
            }
        });
        runTime.start();
        Timer timer = new Timer(300, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int size;
                List list = FuelTunePane.this.incomingDataPoints;
                synchronized (list) {
                    size = FuelTunePane.this.incomingDataPoints.size();
                }
                incomingBufferSize.setText(size + " records in buffer");
            }
        });
        timer.start();
        this.upload.setEnabled(false);
        this.content.add((Component)topPanel, "North");
        JPanel rightPanel = new JPanel(new GridLayout(2, 1));
        rightPanel.add(this.changeMap);
        GaugesGrid grid = new GaugesGrid(1, 3);
        rightPanel.add(grid.panel);
        grid.panel.add(GaugesGridElement.read(config.getChild("1"), Sensor.RPM));
        grid.panel.add(GaugesGridElement.read(config.getChild("2"), Sensor.AFR));
        JPanel middlePanel = new JPanel(new GridLayout(1, 2));
        middlePanel.add(this.veTable);
        middlePanel.add(rightPanel);
        this.content.add((Component)middlePanel, "Center");
        this.initTable(this.veTable);
        this.initTable(this.changeMap);
    }

    private void uploadCurrentResukt() {
        byte[] newVeMap = this.newVeMap;
        BinaryProtocol bp = BinaryProtocol.instance;
        if (newVeMap == null || bp == null) {
            return;
        }
        ConfigurationImage ci = bp.getController().clone();
        System.arraycopy(newVeMap, 0, ci.getContent(), Fields.VETABLE.getOffset(), newVeMap.length);
        Runnable afterBurn = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FuelTunePane.this.doClean();
                        FuelTunePane.this.reloadVeTable();
                    }
                });
            }
        };
        UploadChanges.scheduleUpload(ci, afterBurn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClean() {
        List<FuelDataPoint> list = this.incomingDataPoints;
        synchronized (list) {
            this.incomingDataPoints.clear();
        }
    }

    private static void loadData(Table table, byte[] content, int offset) {
        table.reset();
        table.setStorageAddress(offset);
        table.setStorageType(99);
        table.populateTable(content, 0);
        table.drawTable();
    }

    private void initTable(Table3D table) {
        table.setSizeX(16);
        table.setSizeY(16);
        table.getXAxis().setDataSize(16);
        table.getYAxis().setDataSize(16);
        table.getXAxis().setAxisParent(table);
        table.getYAxis().setAxisParent(table);
        table.setBorder(BorderFactory.createLineBorder(Color.red));
        table.addScale(new Scale());
        table.getXAxis().addScale(new Scale());
        table.getYAxis().addScale(new Scale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJob() {
        float[][] veTable = new float[16][16];
        this.loadMap(veTable, Fields.VETABLE.getOffset());
        this.logMap("source", veTable);
        ArrayList<stDataOnline> data = new ArrayList<stDataOnline>();
        List<FuelDataPoint> list = this.incomingDataPoints;
        synchronized (list) {
            for (FuelDataPoint point : this.incomingDataPoints) {
                data.add(point.asDataOnline());
            }
            this.incomingDataPoints.clear();
        }
        this.writeDataPoints(data);
        Result a = FuelAutoTune.INSTANCE.process(false, data, 0.1, 14.7, veTable);
        float[][] result = a.getKgbcRES();
        this.logMap("result", result);
        this.newVeMap = this.toByteArray(result);
        FuelTunePane.loadData(this.changeMap, this.newVeMap, 0);
        this.upload.setEnabled(true);
    }

    private void writeDataPoints(List<stDataOnline> data) {
        DataOutputStream dos = this.getTuneLogStream();
        if (dos == null) {
            return;
        }
        try {
            dos.writeBytes("Running with " + data.size() + " points\r\n");
            dos.writeBytes("AFR\tRPM\tload\r\n");
            for (stDataOnline point : data) {
                dos.writeBytes(point.AFR + "\t" + point.getRpm() + "\t" + point.getEngineLoad() + "\r\n");
            }
        }
        catch (IOException e) {
            FileLog.MAIN.logLine("Error writing auto-tune log");
        }
    }

    private void logMap(String msg, float[][] table) {
        DataOutputStream dos = this.getTuneLogStream();
        if (dos == null) {
            return;
        }
        try {
            dos.writeBytes(new Date() + ": " + msg + "\r\n");
            for (int rpmIndex = 0; rpmIndex < 16; ++rpmIndex) {
                dos.writeChar(9);
                dos.writeBytes(Float.toString(this.veRpmBins[rpmIndex]));
            }
            dos.writeBytes("\r\n");
            for (int loadIndex = 0; loadIndex < 16; ++loadIndex) {
                dos.writeBytes(Float.toString(this.veLoadBins[loadIndex]));
                for (int rpmIndex = 0; rpmIndex < 16; ++rpmIndex) {
                    dos.writeChar(9);
                    float v = table[loadIndex][rpmIndex];
                    dos.writeBytes(Float.toString(v));
                }
                dos.writeBytes("\r\n");
            }
            dos.flush();
        }
        catch (IOException e) {
            FileLog.MAIN.logLine("Error writing auto-tune log");
        }
    }

    private DataOutputStream getTuneLogStream() {
        if (this.dos == null) {
            String fileName = "out/tune_" + FileLog.getDate() + ".txt";
            try {
                this.dos = new DataOutputStream(new FileOutputStream(fileName));
            }
            catch (FileNotFoundException e) {
                FileLog.MAIN.logLine("Error creating " + fileName + ":" + e);
            }
        }
        return this.dos;
    }

    private byte[] toByteArray(float[][] output) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int loadIndex = 0; loadIndex < 16; ++loadIndex) {
                for (int rpmIndex = 0; rpmIndex < 16; ++rpmIndex) {
                    byte[] b4 = RomAttributeParser.floatToByte(output[loadIndex][rpmIndex], 2);
                    baos.write(b4);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void showContent() {
        final SensorCentral sc = SensorCentral.getInstance();
        sc.addListener(Sensor.RPM, new SensorCentral.SensorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSensorUpdate(double value) {
                if (!FuelTunePane.this.collect.isSelected()) {
                    return;
                }
                int rpm = (int)value;
                double engineLoad = sc.getValue(Sensor.MAP);
                double afr = sc.getValue(Sensor.AFR);
                double deltaTps = sc.getValue(Sensor.deltaTps);
                double clt = sc.getValue(Sensor.CLT);
                FuelDataPoint newPoint = new FuelDataPoint(rpm, engineLoad, afr);
                List list = FuelTunePane.this.incomingDataPoints;
                synchronized (list) {
                    FuelTunePane.this.incomingDataPoints.add(newPoint);
                }
            }
        });
        this.loadArray(this.veLoadBins, veLoadOffset);
        this.loadArray(this.veRpmBins, veRpmOffset);
        byte[] content = this.reloadVeTable();
        FuelTunePane.loadData(this.changeMap.getXAxis(), content, veRpmOffset);
        FuelTunePane.loadData(this.changeMap.getYAxis(), content, veLoadOffset);
    }

    private byte[] reloadVeTable() {
        BinaryProtocol bp = BinaryProtocol.instance;
        byte[] content = bp.getController().getContent();
        FuelTunePane.loadData(this.veTable.getXAxis(), content, veRpmOffset);
        FuelTunePane.loadData(this.veTable.getYAxis(), content, veLoadOffset);
        FuelTunePane.loadData(this.veTable, content, Fields.VETABLE.getOffset());
        return content;
    }

    private void loadMap(float[][] map, int offset) {
        for (int engineLoadIndex = 0; engineLoadIndex < map.length; ++engineLoadIndex) {
            this.loadArray(map[engineLoadIndex], offset + engineLoadIndex * 4 * 16);
        }
    }

    private void loadArray(float[] array, int offset) {
        BinaryProtocol bp = BinaryProtocol.instance;
        if (bp == null) {
            FileLog.MAIN.logLine("bp not ready");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = BaseConfigField.getByteBuffer(bp.getController(), offset + 4 * i).getFloat();
        }
        System.out.println("Loaded " + Arrays.toString(array));
    }

    public Component getContent() {
        return this.content;
    }

    private class FuelDataPoint {
        private final int rpm;
        private final double engineLoad;
        private final double afr;
        private final int rpmIndex;
        private final int engineLoadIndex;

        public FuelDataPoint(int rpm, double engineLoad, double afr) {
            this.rpm = rpm;
            this.engineLoad = engineLoad;
            this.afr = afr;
            this.rpmIndex = Math.max(0, BinarySearch.binarySearch(rpm, FuelTunePane.this.veRpmBins));
            this.engineLoadIndex = Math.max(0, BinarySearch.binarySearch(engineLoad, FuelTunePane.this.veLoadBins));
        }

        public stDataOnline asDataOnline() {
            return new stDataOnline(this.afr, this.rpmIndex, this.engineLoadIndex, this.rpm, this.engineLoad);
        }
    }
}

