/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.Sensor;
import com.rusefi.ui.SensorLiveGraph;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.widgets.JPanelWithListener;
import com.rusefi.ui.widgets.SensorGauge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class GaugesGridElement {
    private static final String GAUGE_TYPE = "gauge";
    private static final String IS_LIVE_GRAPH = "type";
    private final JPanelWithListener wrapper = new JPanelWithListener(new BorderLayout());
    private final Node config;

    private GaugesGridElement(Node config) {
        this.config = config;
    }

    private Component createLiveBarElement(final Node config, final Sensor defaultSensor) {
        this.wrapper.setLayout(new GridLayout(2, 1));
        JMenuItem switchToGauge = new JMenuItem("Switch to Gauge Mode");
        switchToGauge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GaugesGridElement.this.wrapper.removeAllChildrenAndListeners();
                config.setBoolProperty(GaugesGridElement.IS_LIVE_GRAPH, false);
                GaugesGridElement.this.createGauge(defaultSensor);
            }
        });
        this.wrapper.add(new SensorLiveGraph(config.getChild("top"), defaultSensor, switchToGauge));
        this.wrapper.add(new SensorLiveGraph(config.getChild("bottom"), Sensor.RPM, switchToGauge));
        return this.wrapper;
    }

    private Component createGauge(final Sensor sensor) {
        SensorGauge.GaugeChangeListener gaugeChangeListener = new SensorGauge.GaugeChangeListener(){

            @Override
            public void onSensorChange(Sensor sensor) {
                GaugesGridElement.this.config.setProperty(GaugesGridElement.GAUGE_TYPE, sensor.name());
            }
        };
        JMenuItem switchToLiveGraph = new JMenuItem("Switch to Live Graph");
        switchToLiveGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GaugesGridElement.this.wrapper.removeAllChildrenAndListeners();
                GaugesGridElement.this.config.setBoolProperty(GaugesGridElement.IS_LIVE_GRAPH, true);
                GaugesGridElement.this.createLiveBarElement(GaugesGridElement.this.config, sensor);
            }
        });
        this.wrapper.setLayout(new BorderLayout());
        SensorGauge.createGaugeBody(sensor, this.wrapper, gaugeChangeListener, switchToLiveGraph);
        return this.wrapper;
    }

    public static Component read(Node config, Sensor defaultSensor) {
        if (config.getBoolProperty(IS_LIVE_GRAPH)) {
            return new GaugesGridElement(config).createLiveBarElement(config, defaultSensor);
        }
        String gaugeName = config.getProperty(GAUGE_TYPE, defaultSensor.name());
        Sensor sensor = Sensor.lookup(gaugeName, defaultSensor);
        return new GaugesGridElement(config).createGauge(sensor);
    }
}

