/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.FileLog;
import com.rusefi.core.Sensor;
import com.rusefi.ui.GaugesGrid;
import com.rusefi.ui.GaugesGridElement;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.SizeSelectorPanel;
import com.rusefi.ui.WarningPanel;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.storage.PersistentConfiguration;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import com.rusefi.ui.widgets.DetachedSensor;
import com.rusefi.ui.widgets.PopupMenuButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;

public class GaugesPanel {
    private static final Sensor[] DEFAULT_LAYOUT = new Sensor[]{Sensor.RPM, Sensor.MAF, Sensor.CLT, Sensor.IAT, Sensor.TPS, Sensor.MAP, Sensor.MAP_RAW, Sensor.T_CHARGE, Sensor.DWELL1, Sensor.DWELL0, Sensor.DUTY0, Sensor.ADVANCE0, Sensor.FUEL, Sensor.BARO, Sensor.FUEL_CLT, Sensor.FUEL_IAT, Sensor.FUEL_LAG, Sensor.AFR, Sensor.DEFAULT_FUEL, Sensor.TIMING, Sensor.VREF};
    private static final String GAUGES_ROWS = "gauges_rows";
    private static final String GAUGES_COLUMNS = "gauges_cols";
    private static final String SHOW_MESSAGES = "show_messages";
    private static final String SHOW_RPM = "show_rpm";
    private static final String SPLIT_LOCATION = "SPLIT_LOCATION";
    public static final String DISABLE_LOGS = "DISABLE_LOGS";
    public static boolean IS_PAUSED;
    private final JPanel content = new JPanel(new BorderLayout());
    private final GaugesGrid gauges;
    private final Node config;
    private boolean showRpmPanel = true;
    private boolean showMessagesPanel = true;
    private final JPanel lowerRpmPanel = new JPanel(new FlowLayout(1, 0, 0));
    private final JPanel messagesPanel = new JPanel(new BorderLayout());
    private final JSplitPane middleSplitPanel;

    public GaugesPanel(final Node config) {
        this.gauges = new GaugesGrid(3, 5);
        this.config = config;
        this.showRpmPanel = config.getBoolProperty(SHOW_RPM, true);
        this.showMessagesPanel = config.getBoolProperty(SHOW_MESSAGES, true);
        this.prepareMessagesPanel();
        this.lowerRpmPanel.add(new RpmLabel(15).getContent());
        int rows = config.getIntProperty(GAUGES_ROWS, 3);
        int columns = config.getIntProperty(GAUGES_COLUMNS, 7);
        this.setSensorGridDimensions(rows, columns);
        this.middleSplitPanel = new JSplitPane(1, this.createMiddleLeftPanel(), this.messagesPanel);
        this.content.add((Component)this.createTopPanel(config), "North");
        this.content.add((Component)this.middleSplitPanel, "Center");
        this.content.add((Component)new WarningPanel().getPanel(), "South");
        this.applyShowFlags();
        int splitLocation = config.getIntProperty(SPLIT_LOCATION, -1);
        if (splitLocation != -1) {
            this.middleSplitPanel.setDividerLocation(splitLocation);
        }
        this.middleSplitPanel.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                config.setProperty(GaugesPanel.SPLIT_LOCATION, GaugesPanel.this.middleSplitPanel.getDividerLocation());
            }
        });
    }

    @NotNull
    private JPanel createMiddleLeftPanel() {
        JPanel middleLeftPanel = new JPanel(new BorderLayout());
        middleLeftPanel.add((Component)this.gauges.panel, "Center");
        middleLeftPanel.add((Component)this.lowerRpmPanel, "South");
        return middleLeftPanel;
    }

    @NotNull
    private JPanel createTopPanel(Node config) {
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add((Component)this.createLeftTopPanel(), "Center");
        upperPanel.add((Component)this.createRightTopPanel(config), "East");
        return upperPanel;
    }

    @NotNull
    private JPanel createRightTopPanel(Node config) {
        JPanel rightUpperPanel = new JPanel(new FlowLayout(2, 5, 0));
        final JPopupMenu selectorMenu = new JPopupMenu();
        selectorMenu.add(new SizeSelectorPanel(new SizeSelectorPanel.SizeSelectorListener(){

            @Override
            public void onSelected(int row, int column) {
                System.out.println("new size " + row + "/" + column);
                GaugesPanel.this.setSensorGridDimensions(row, column);
            }
        }));
        JButton selector = new JButton("O");
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                selectorMenu.show(c, -1, c.getHeight());
            }
        });
        rightUpperPanel.add(selector);
        PopupMenuButton menuButton = new PopupMenuButton("#", this.createMenu(config));
        rightUpperPanel.add(menuButton);
        return rightUpperPanel;
    }

    @NotNull
    private JPopupMenu createMenu(final Node config) {
        JPopupMenu menu = new JPopupMenu();
        final JCheckBoxMenuItem saveDetailedLogs = new JCheckBoxMenuItem("Save detailed logs");
        saveDetailedLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLog.suspendLogging = !saveDetailedLogs.isSelected();
                PersistentConfiguration.getConfig().getRoot().setBoolProperty(GaugesPanel.DISABLE_LOGS, FileLog.suspendLogging);
            }
        });
        saveDetailedLogs.setSelected(!FileLog.suspendLogging);
        final JCheckBoxMenuItem showRpmItem = new JCheckBoxMenuItem("Show RPM");
        final JCheckBoxMenuItem showCommandsItem = new JCheckBoxMenuItem("Show Commands");
        showRpmItem.setSelected(this.showRpmPanel);
        ActionListener showCheckboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GaugesPanel.this.showRpmPanel = showRpmItem.isSelected();
                GaugesPanel.this.showMessagesPanel = showCommandsItem.isSelected();
                config.setProperty(GaugesPanel.SHOW_RPM, GaugesPanel.this.showRpmPanel);
                config.setProperty(GaugesPanel.SHOW_MESSAGES, GaugesPanel.this.showMessagesPanel);
                GaugesPanel.this.applyShowFlags();
                GaugesPanel.this.middleSplitPanel.setDividerLocation(0.5);
            }
        };
        showRpmItem.addActionListener(showCheckboxListener);
        showCommandsItem.addActionListener(showCheckboxListener);
        menu.add(showRpmItem);
        showCommandsItem.setSelected(this.showMessagesPanel);
        menu.add(showCommandsItem);
        menu.add(new JPopupMenu.Separator());
        menu.add(saveDetailedLogs);
        menu.add(new JPopupMenu("Reset Config"));
        return menu;
    }

    private void prepareMessagesPanel() {
        MessagesPanel mp = new MessagesPanel(null);
        this.messagesPanel.add("North", mp.getButtonPanel());
        this.messagesPanel.add("Center", mp.getMessagesScroll());
    }

    @NotNull
    private JPanel createLeftTopPanel() {
        JPanel leftUpperPanel = new JPanel(new FlowLayout(0, 5, 0));
        leftUpperPanel.add(this.createPauseButton());
        leftUpperPanel.add(this.createSaveImageButton());
        leftUpperPanel.add(new RpmLabel(2).getContent());
        AnyCommand command = AnyCommand.createField(this.config, false, false);
        leftUpperPanel.add(command.getContent());
        return leftUpperPanel;
    }

    private Component createPauseButton() {
        final JButton pauseButton = UiUtils.createPauseButton();
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IS_PAUSED = !IS_PAUSED;
                UiUtils.setPauseButtonText(pauseButton, IS_PAUSED);
            }
        });
        return pauseButton;
    }

    @NotNull
    private JButton createSaveImageButton() {
        JButton saveImageButton = UiUtils.createSaveImageButton();
        saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = FileLog.getDate() + "_gauges.png";
                UiUtils.saveImageWithPrompt(fileName, GaugesPanel.this.content, ((GaugesPanel)GaugesPanel.this).gauges.panel);
            }
        });
        return saveImageButton;
    }

    private void setSensorGridDimensions(int rows, int columns) {
        this.gauges.setLayout(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            Component element = GaugesGridElement.read(this.config.getChild("element_" + i), DEFAULT_LAYOUT[i]);
            this.gauges.panel.add(element);
        }
        this.saveConfig(rows, columns);
    }

    private void saveConfig(int rows, int columns) {
        this.config.setProperty(GAUGES_ROWS, rows);
        this.config.setProperty(GAUGES_COLUMNS, columns);
    }

    private void applyShowFlags() {
        this.lowerRpmPanel.setVisible(this.showRpmPanel);
        this.messagesPanel.setVisible(this.showMessagesPanel);
    }

    public JComponent getContent() {
        return this.content;
    }

    static {
        if (DEFAULT_LAYOUT.length != 21) {
            throw new IllegalStateException("Not expected " + DEFAULT_LAYOUT.length);
        }
    }

    public static enum DetachedRepository {
        INSTANCE;

        public static final String COUNT = "count";
        public static final String DETACHED = "detached";
        private List<DetachedSensor> list = new ArrayList<DetachedSensor>();
        private Node config;

        public void add(DetachedSensor detachedSensor) {
            this.list.add(detachedSensor);
            this.saveConfig();
        }

        public void remove(DetachedSensor detachedSensor) {
            this.list.remove(detachedSensor);
            this.saveConfig();
        }

        public void load() {
            int count = this.config.getIntProperty(COUNT, 0);
            for (int i = 0; i < count; ++i) {
                DetachedSensor.create(this.config.getChild(DETACHED + i));
            }
        }

        public void saveConfig() {
            this.config.setProperty(COUNT, this.list.size());
            int index = 0;
            for (DetachedSensor sensor : this.list) {
                sensor.saveConfig(this.config.getChild(DETACHED + index++));
            }
        }

        public void init(Node config) {
            this.config = config;
        }
    }
}

