/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.EcuStimulator;
import com.rusefi.core.MessagesCentral;
import com.rusefi.models.Point3D;
import com.rusefi.models.Range;
import com.rusefi.models.XYData;
import com.rusefi.ui.ChartHelper;
import java.awt.Component;
import javax.swing.JPanel;
import net.ericaro.surfaceplotter.DefaultSurfaceModel;

public class Live3DReport {
    public static final Range KEY_RANGE = new Range(1.5f, 4.0f);
    private final XYData primary = new XYData();
    private final XYData secondary = null;
    private final JPanel control;
    private static final String KEY = "map_adjusted: ";

    public Live3DReport() {
        final DefaultSurfaceModel model = ChartHelper.createDefaultSurfaceModel(this.primary, EcuStimulator.RPM_RANGE, KEY_RANGE, this.secondary);
        this.control = ChartHelper.create3DControl(this.primary, model, "Live Data");
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                if (!message.startsWith(Live3DReport.KEY)) {
                    return;
                }
                message = message.substring(Live3DReport.KEY.length());
                Live3DReport.this.addPoint(message, model);
            }
        });
    }

    private void addPoint(String message, DefaultSurfaceModel model) {
        String[] v = message.split(" ");
        if (v.length != 3) {
            return;
        }
        int rpm = Integer.valueOf(v[0]);
        float key = (float)Integer.valueOf(v[1]).intValue() / 100.0f;
        float value = (float)Integer.valueOf(v[2]).intValue() / 100.0f;
        this.primary.setPoint(new Point3D(rpm, (double)key, value));
        this.primary.saveToFile("_mult.csv");
        model.plot().execute();
    }

    public Component getControl() {
        return this.control;
    }
}

