/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import com.rusefi.Launcher;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.WarningPanel;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.widgets.AnyCommand;
import com.rusefi.ui.widgets.IdleLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MessagesPane {
    private static final String HELP_URL = "http://rusefi.com/wiki/index.php?title=Manual:Software:dev_console_commands";
    private final JPanel content = new JPanel(new BorderLayout()){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(250, size.height);
        }
    };
    private final JButton fontButton = new JButton("Font");

    public MessagesPane(final Node config) {
        JPanel topPanel = new JPanel(new FlowLayout(0, 5, 0));
        AnyCommand command = AnyCommand.createArea(config, config.getProperty("last_value"), true, false);
        final MessagesPanel upperPanel = new MessagesPanel(command.getContent());
        upperPanel.loadFont(config);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)upperPanel.getMessagesScroll(), "Center");
        middlePanel.add(new RecentCommands().getContent(), "East");
        this.content.add((Component)middlePanel, "Center");
        upperPanel.getButtonPanel().add(new RpmLabel(2).getContent());
        topPanel.add(upperPanel.getButtonPanel());
        topPanel.add(this.fontButton);
        topPanel.add(new URLLabel("Click here for online help", HELP_URL));
        this.content.add((Component)topPanel, "North");
        JPanel statsPanel = new JPanel(new FlowLayout(0));
        statsPanel.add(new RpmLabel().getContent());
        statsPanel.add(new IdleLabel());
        statsPanel.add(new WarningPanel().getPanel());
        this.content.add((Component)statsPanel, "South");
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser fc = new JFontChooser(Launcher.getFrame());
                fc.setLocationRelativeTo(MessagesPane.this.fontButton);
                if (fc.showDialog(upperPanel.getFont()) == JFontChooser.OK_OPTION) {
                    upperPanel.setFont(fc.getFont(), config);
                }
            }
        });
    }

    public JComponent getContent() {
        return this.content;
    }
}

