/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.ui.MessagesView;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MessagesPanel {
    private static final String FONT_SIZE = "font_size";
    private static final String FONT_NAME = "font_name";
    private final MessagesView messagesView = new MessagesView();
    private final JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 0));

    public MessagesPanel(JComponent extraButton) {
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)this.messagesView.messagesScroll, "Center");
        final JButton pauseButton = UiUtils.createPauseButton();
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessagesPanel.this.setPaused(pauseButton, !((MessagesPanel)MessagesPanel.this).messagesView.isPaused);
            }
        });
        JButton clearButton = UiUtils.createClearButton();
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessagesPanel.this.messagesView.clear();
                MessagesPanel.this.setPaused(pauseButton, false);
            }
        });
        this.buttonPanel.add(clearButton);
        this.buttonPanel.add(pauseButton);
        if (extraButton != null) {
            this.buttonPanel.add(extraButton);
        }
    }

    private void setPaused(JButton pauseButton, boolean isPaused) {
        this.messagesView.isPaused = isPaused;
        UiUtils.setPauseButtonText(pauseButton, this.messagesView.isPaused);
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JScrollPane getMessagesScroll() {
        return this.messagesView.messagesScroll;
    }

    public Font getFont() {
        return this.messagesView.messages.getFont();
    }

    public void setFont(Font font, Node config) {
        this.messagesView.messages.setFont(font);
        config.setProperty(FONT_SIZE, font.getSize());
        config.setProperty(FONT_NAME, font.getName());
    }

    public void loadFont(Node config) {
        Font f = this.getFont();
        int size = config.getIntProperty(FONT_SIZE, f.getSize());
        String name = config.getProperty(FONT_NAME, f.getName());
        this.setFont(new Font(f.getName(), f.getStyle(), size), config);
    }
}

