/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.MessagesCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.serial.PortHolder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MessagesView {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH_mm");
    private static final int MAX_SIZE = 50000;
    private final Style bold;
    private final Style italic;
    protected boolean isPaused;
    protected final JTextPane messages = new JTextPane(){

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
        }
    };
    public final JScrollPane messagesScroll = new JScrollPane(this.messages, 22, 30);

    public MessagesView() {
        this.messages.setEditable(false);
        StyledDocument d = (StyledDocument)this.messages.getDocument();
        this.bold = d.addStyle("StyleName", null);
        this.bold.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        this.italic = d.addStyle("StyleName", null);
        this.italic.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.TRUE);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                String date = DATE_FORMAT.format(new Date());
                if (!MessagesView.this.isPaused) {
                    MessagesView.this.append(date + ": " + clazz.getSimpleName() + ": " + message, clazz);
                }
            }
        });
    }

    private void append(String line, Class clazz) {
        Document d = this.messages.getDocument();
        if (d.getLength() > 50000) {
            this.clearMessages(d);
        }
        try {
            d.insertString(d.getLength(), line + "\r\n", this.getStyle(clazz));
            this.messages.select(d.getLength(), d.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    private AttributeSet getStyle(Class clazz) {
        if (clazz == CommandQueue.class) {
            return this.bold;
        }
        if (clazz == PortHolder.class) {
            return this.italic;
        }
        return null;
    }

    private void clearMessages(Document d) {
        try {
            d.remove(0, d.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void clear() {
        Document d = this.messages.getDocument();
        this.clearMessages(d);
    }
}

