/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.AverageAnglesUtil;
import com.rusefi.FileLog;
import com.rusefi.core.MessagesCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.storage.PersistentConfiguration;
import com.rusefi.ui.util.UiUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class RecentCommands {
    private static final int NUMBER_OF_COMMANDS = 40;
    private static final String KEY = "recent_commands";
    private static final String DELIMETER = "|";
    private static final String STOPENGINE = "stopengine";
    private static final String SHOWCONFIG = "showconfig";
    private static final String HELP = "help";
    private static final String ANALOGINFO = "analoginfo";
    private static final String TRIGGERINFO = "triggerinfo";
    private static final String IDLEINFO = "idleinfo";
    private static final String ALTINFO = "altinfo";
    private static final String TPSINFO = "tpsinfo";
    private static final String ACCELINFO = "accelinfo";
    private static final String CANINFO = "caninfo";
    private static final String TSINFO = "tsinfo";
    private static final String SPEEDINFO = "speedinfo";
    private static final String joystickINFO = "joystickinfo";
    private static final String FUELINFO = "fuelinfo";
    private static final String TEMPINFO = "tempinfo";
    private static final String HIPINFO = "hipinfo";
    private static final String SDINFO = "sdinfo";
    private static final String FSIOINFO = "fsioinfo";
    private static final String PINS = "pins";
    private static final Map<String, Icon> COMMAND_ICONS = new TreeMap<String, Icon>(String.CASE_INSENSITIVE_ORDER);
    private final JPanel content = new JPanel(new GridLayout(41, 1));
    private static final LinkedHashMap<Entry, Object> entries;
    private final AtomicBoolean reentrant = new AtomicBoolean();
    private final JScrollPane messagesScroll = new JScrollPane(this.content, 22, 30);

    public RecentCommands() {
        CommandQueue.getInstance().addListener(new CommandQueue.CommandQueueListener(){

            @Override
            public void onCommand(String command) {
                if (!RecentCommands.this.reentrant.get()) {
                    RecentCommands.this.add(command);
                }
            }
        });
        String value = PersistentConfiguration.getConfig().getRoot().getProperty(KEY, null);
        if (value != null && value.trim().length() > 5) {
            this.unpack(value);
        } else {
            this.addDefaults();
        }
    }

    private void unpack(String value) {
        entries.clear();
        for (String command : value.split("\\|")) {
            this.add(command);
        }
    }

    private void addDefaults() {
        this.add(HELP);
        this.add(SHOWCONFIG);
        this.add(STOPENGINE);
        this.add(ANALOGINFO);
        this.add(TRIGGERINFO);
        this.add(TSINFO);
        this.add(SPEEDINFO);
        this.add(joystickINFO);
        this.add(CANINFO);
        this.add("writeconfig");
        this.add("rewriteconfig");
        this.add("enable injection");
        this.add("disable injection");
        this.add("enable ignition");
        this.add("disable ignition");
        this.add("enable self_stimulation");
        this.add("disable self_stimulation");
        this.add("blipidle 80 2000");
        this.add("set_idle_position 50");
        this.add("sparkbench 5 400 2");
        this.add("fuelbench 5 400 2");
        this.add(IDLEINFO);
        this.add(ALTINFO);
        this.add(TPSINFO);
        this.add(ACCELINFO);
        this.add(FUELINFO);
        this.add(TEMPINFO);
        this.add(HIPINFO);
        this.add(SDINFO);
        this.add(FSIOINFO);
        this.add(PINS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String command) {
        LinkedHashMap<Entry, Object> linkedHashMap = entries;
        synchronized (linkedHashMap) {
            entries.put(new Entry(command), null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RecentCommands.this.content.removeAll();
                if (LinkManager.isLogViewer()) {
                    RecentCommands.this.content.add(RecentCommands.createButton());
                }
                JButton reset = new JButton(UiUtils.loadIcon("undo.jpg"));
                reset.setContentAreaFilled(false);
                reset.setFocusPainted(false);
                reset.setBorder(BorderFactory.createEmptyBorder());
                RecentCommands.this.content.add(UiUtils.wrap(reset));
                reset.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        entries.clear();
                        RecentCommands.this.addDefaults();
                    }
                });
                LinkedHashMap linkedHashMap = entries;
                synchronized (linkedHashMap) {
                    TreeSet sorted = new TreeSet();
                    sorted.addAll(entries.keySet());
                    for (Entry entry : sorted) {
                        RecentCommands.this.content.add(RecentCommands.createButton(RecentCommands.this.reentrant, entry.command));
                    }
                }
                UiUtils.trueRepaint(RecentCommands.this.content.getParent());
                UiUtils.trueLayout(RecentCommands.this.content.getParent());
            }
        });
        PersistentConfiguration.getConfig().getRoot().setProperty(KEY, this.pack());
    }

    public static JComponent createButton(final AtomicBoolean reentrant, final String command) {
        JButton button = new JButton(command);
        Icon icon = COMMAND_ICONS.get(command);
        if (icon != null) {
            button.setIcon(icon);
        }
        button.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 5));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                reentrant.set(true);
                int timeout = CommandQueue.getTimeout(command);
                CommandQueue.getInstance().write(command, timeout);
                reentrant.set(false);
            }
        });
        return UiUtils.wrap(button);
    }

    public Component getContent() {
        return this.messagesScroll;
    }

    public String pack() {
        StringBuilder sb = new StringBuilder();
        for (Entry command : entries.keySet()) {
            if (sb.length() != 0) {
                sb.append(DELIMETER);
            }
            sb.append(command.command);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRecent(int index) {
        ArrayList<Entry> elements;
        index = Math.max(0, index);
        LinkedHashMap<Entry, Object> linkedHashMap = entries;
        synchronized (linkedHashMap) {
            elements = new ArrayList<Entry>(entries.keySet());
        }
        if (index >= elements.size()) {
            return ((Entry)elements.get(0)).command;
        }
        return ((Entry)elements.get(elements.size() - 1 - index)).command;
    }

    public static JButton createButton() {
        JButton button = new JButton("Read trigger log");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = UiUtils.getFileChooser(new FileNameExtensionFilter("CSV files", "csv"));
                if (fc.showSaveDialog(null) == 0) {
                    String report;
                    String fileName = fc.getSelectedFile().getAbsolutePath();
                    try {
                        report = AverageAnglesUtil.runUtil(fileName, FileLog.LOGGER);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    MessagesCentral.getInstance().postMessage(AverageAnglesUtil.class, report);
                }
            }
        });
        return button;
    }

    static {
        COMMAND_ICONS.put(STOPENGINE, UiUtils.loadIcon("stop.jpg"));
        ImageIcon infoIcon = UiUtils.loadIcon("info.png");
        COMMAND_ICONS.put(SHOWCONFIG, infoIcon);
        COMMAND_ICONS.put(HELP, UiUtils.loadIcon("help.jpg"));
        COMMAND_ICONS.put(ANALOGINFO, infoIcon);
        COMMAND_ICONS.put(TRIGGERINFO, UiUtils.loadIcon("trigger.jpg"));
        COMMAND_ICONS.put(IDLEINFO, infoIcon);
        COMMAND_ICONS.put(ALTINFO, UiUtils.loadIcon("alternator.jpg"));
        COMMAND_ICONS.put(ACCELINFO, infoIcon);
        COMMAND_ICONS.put(TSINFO, infoIcon);
        COMMAND_ICONS.put(TPSINFO, infoIcon);
        COMMAND_ICONS.put(joystickINFO, UiUtils.loadIcon("joystick.png"));
        COMMAND_ICONS.put(CANINFO, infoIcon);
        COMMAND_ICONS.put(FUELINFO, infoIcon);
        COMMAND_ICONS.put(TEMPINFO, infoIcon);
        COMMAND_ICONS.put(HIPINFO, UiUtils.loadIcon("knock.jpg"));
        COMMAND_ICONS.put(SDINFO, UiUtils.loadIcon("sdinfo.jpg"));
        COMMAND_ICONS.put(FSIOINFO, infoIcon);
        COMMAND_ICONS.put(PINS, infoIcon);
        COMMAND_ICONS.put("writeconfig", UiUtils.loadIcon("writeconfig.jpg"));
        COMMAND_ICONS.put(SPEEDINFO, UiUtils.loadIcon("speedinfo.jpg"));
        entries = new LinkedHashMap<Entry, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Entry, Object> eldest) {
                return this.size() > 40;
            }
        };
    }

    static class Entry
    implements Comparable<Entry> {
        private final String command;

        Entry(String command) {
            this.command = command;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return !(this.command == null ? entry.command != null : !this.command.equals(entry.command));
        }

        public int hashCode() {
            return this.command != null ? this.command.hashCode() : 0;
        }

        public String toString() {
            return "{command='" + this.command + '\'' + '}';
        }

        @Override
        public int compareTo(Entry o) {
            return this.command.compareTo(o.command);
        }
    }
}

