/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.ConnectionStatus;
import com.rusefi.ui.RpmModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RpmLabel {
    private static final String NO_CONNECTION = "N/C";
    private final JPanel content = new JPanel(new FlowLayout(0, 5, 0));
    private final JLabel rpmValue = new JLabel("N/C");
    private final JLabel rpmCaption = new JLabel("RPM:");

    public RpmLabel() {
        this(1);
    }

    public RpmLabel(int size) {
        this.rpmValue.setForeground(Color.red);
        this.content.setBorder(BorderFactory.createLineBorder(Color.white));
        this.content.add(this.rpmCaption);
        this.content.add((Component)this.rpmValue, "grow, wrap");
        RpmModel.getInstance().addListener(new RpmModel.RpmListener(){

            @Override
            public void onRpmChange(RpmModel rpm) {
                int value = rpm.getSmoothedValue();
                if (value == -1) {
                    RpmLabel.this.rpmValue.setText("Noise");
                } else {
                    RpmLabel.this.rpmValue.setText(value + "");
                }
            }
        });
        ConnectionStatus.INSTANCE.addListener(new ConnectionStatus.Listener(){

            @Override
            public void onConnectionStatus(boolean isConnected) {
                if (isConnected) {
                    RpmLabel.this.rpmValue.setText("" + SensorCentral.getInstance().getValue(Sensor.RPM));
                    RpmLabel.this.rpmValue.setForeground(Color.green);
                } else {
                    RpmLabel.this.rpmValue.setText(RpmLabel.NO_CONNECTION);
                    RpmLabel.this.rpmValue.setForeground(Color.red);
                }
            }
        });
        this.setSize(size);
    }

    public JPanel getContent() {
        return this.content;
    }

    public RpmLabel setSize(int size) {
        Font f = this.rpmCaption.getFont();
        int fontSize = size * f.getSize();
        Font font = new Font(f.getName(), f.getStyle(), fontSize);
        this.setFont(font);
        return this;
    }

    private void setFont(Font font) {
        this.rpmCaption.setFont(font);
        this.rpmValue.setFont(font);
    }
}

