/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.config.BitConfigField;
import com.rusefi.ui.config.ConfigField;
import com.rusefi.ui.config.DialogModel;
import com.rusefi.ui.config.EnumConfigField;
import com.rusefi.ui.config.IniFileModel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SettingsTab {
    public static final String WRITECONFIG = "writeconfig";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JPanel panel = new JPanel(new GridLayout(1, 3));
    private final JButton dialog = new JButton();
    private final JPanel dialogBody = new JPanel();

    public SettingsTab() {
        UiUtils.showLoadingMessage(this.content);
    }

    public Component createPane() {
        return this.content;
    }

    public void showContent() {
        final Map<String, DialogModel> dialogs = IniFileModel.getinstance().getDialogs();
        if (dialogs.isEmpty()) {
            return;
        }
        this.content.removeAll();
        this.panel.removeAll();
        String firstDialog = new ArrayList<String>(dialogs.keySet()).get(0);
        this.dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                JPopupMenu menu = new JPopupMenu();
                menu.setLayout(new GridLayout(dialogs.keySet().size() / 2 + 1, 2));
                for (final String name : dialogs.keySet()) {
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SettingsTab.this.selectDialog(name);
                        }
                    });
                    menu.add(item);
                }
                menu.show(c, -1, c.getHeight());
            }
        });
        this.selectDialog(firstDialog);
        this.panel.add(UiUtils.wrap(this.dialog));
        this.panel.add(this.dialogBody);
        this.panel.add(UiUtils.wrap(RecentCommands.createButton(new AtomicBoolean(), WRITECONFIG)));
        this.content.add(this.panel);
        UiUtils.trueLayout(this.content);
    }

    private void selectDialog(String name) {
        this.dialog.setText(name);
        this.dialogBody.removeAll();
        DialogModel m = IniFileModel.getinstance().getDialogs().get(name);
        this.dialogBody.setLayout(new GridLayout(m.getFields().size() - 5, 1));
        for (DialogModel.Field f : m.getFields()) {
            if (f.getKey() == null) continue;
            Field field = Field.VALUES.get(f.getKey().toUpperCase());
            if (field == null) {
                throw new NullPointerException("No field for " + f.getKey());
            }
            System.out.println(field);
            JPanel control = field.getType() == FieldType.BIT ? new BitConfigField(field, f.getUiName()).getContent() : (field.getOptions() != null ? new EnumConfigField(field, f.getUiName()).getContent() : new ConfigField(field, f.getUiName()).getContent());
            this.dialogBody.add(control);
        }
        UiUtils.trueLayout(this.dialogBody);
    }
}

