/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.ui.util.FrameHelper;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StatusWindow {
    private static final String CONSOLE_DRIVER_URI = "http://www.st.com/st-web-ui/static/active/en/st_prod_software_internet/resource/technical/software/utility/stsw-link004.zip";
    private final JTextArea log = new JTextArea();
    private final JPanel content = new JPanel(new BorderLayout());
    private final JScrollPane messagesScroll = new JScrollPane(this.log, 22, 30){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 400);
        }
    };
    @NotNull
    protected final FrameHelper frameHelper = new FrameHelper();

    public StatusWindow() {
        this.log.setLineWrap(true);
        this.content.add((Component)new URLLabel("stm32 driver", CONSOLE_DRIVER_URI), "North");
        this.content.add((Component)this.messagesScroll, "Center");
    }

    @NotNull
    public FrameHelper getFrameHelper() {
        return this.frameHelper;
    }

    public JPanel getContent() {
        return this.content;
    }

    public JFrame getFrame() {
        return this.frameHelper.getFrame();
    }

    public void showFrame(String title) {
        this.frameHelper.getFrame().setTitle(title);
        this.frameHelper.showFrame(this.content, false);
        UiUtils.centerWindow(this.frameHelper.getFrame());
        this.log.setText("");
    }

    public void appendMsg(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusWindow.this.log.append(s + "\r\n");
                UiUtils.trueLayout(StatusWindow.this.log);
            }
        });
    }
}

