/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.rusefi.ConfigurationImage;
import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.Field;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionStatus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class BaseConfigField {
    protected final JLabel status = new JLabel("P");
    protected final JPanel panel = new JPanel(new BorderLayout());
    protected final Field field;

    public BaseConfigField(Field field) {
        this.field = field;
        this.status.setToolTipText("Pending...");
    }

    protected void requestInitialValue(final Field field) {
        if (ConnectionStatus.INSTANCE.isConnected()) {
            this.processInitialValue(field);
        } else {
            ConnectionStatus.INSTANCE.addListener(new ConnectionStatus.Listener(){

                @Override
                public void onConnectionStatus(boolean isConnected) {
                    if (ConnectionStatus.INSTANCE.getValue() == ConnectionStatus.Value.CONNECTED) {
                        BaseConfigField.this.processInitialValue(field);
                    }
                }
            });
        }
    }

    private void processInitialValue(Field field) {
        BinaryProtocol bp = BinaryProtocol.instance;
        if (bp == null) {
            return;
        }
        ConfigurationImage ci = bp.getController();
        if (ci == null) {
            return;
        }
        this.loadValue(ci);
    }

    protected abstract void loadValue(ConfigurationImage var1);

    protected void onValueArrived() {
        this.status.setText("");
        this.status.setToolTipText(null);
    }

    protected void sendValue(Field field, String newValue) {
        String msg = field.setCommand() + " " + newValue;
        FileLog.MAIN.logLine("Sending " + msg);
        CommandQueue.getInstance().write(msg);
        this.status.setText("S");
        this.status.setToolTipText("Storing...");
    }

    protected void createUi(String topLabel, Component control) {
        JPanel center = new JPanel(new FlowLayout());
        control.setEnabled(false);
        center.add(this.status);
        center.add(control);
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panel.add((Component)new JLabel(topLabel), "North");
        this.panel.add((Component)center, "Center");
    }

    public JPanel getContent() {
        return this.panel;
    }

    @NotNull
    protected ByteBuffer getByteBuffer(ConfigurationImage ci) {
        return BaseConfigField.getByteBuffer(ci, this.field);
    }

    @NotNull
    public static ByteBuffer getByteBuffer(ConfigurationImage ci, Field field) {
        return BaseConfigField.getByteBuffer(ci, field.getOffset());
    }

    @NotNull
    public static ByteBuffer getByteBuffer(ConfigurationImage ci, int offset) {
        byte[] data = ci.getRange(offset, 4);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        wrapped.order(ByteOrder.LITTLE_ENDIAN);
        return wrapped;
    }
}

