/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.rusefi.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.core.MessagesCentral;
import com.rusefi.ui.config.BaseConfigField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class BitConfigField
extends BaseConfigField {
    private final JCheckBox view = new JCheckBox();
    private boolean ec;

    public BitConfigField(final Field field, String caption) {
        super(field);
        this.createUi(caption, this.view);
        this.requestInitialValue(field);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                String expectedPrefix;
                if (Field.isBitValueMessage(message) && message.startsWith(expectedPrefix = "bit @" + field.getOffset() + "/" + field.getBitOffset() + " is ") && message.length() == expectedPrefix.length() + 1) {
                    message = message.substring(expectedPrefix.length());
                    Boolean value = message.equals("1");
                    BitConfigField.this.setValue(value);
                }
            }
        });
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BitConfigField.this.ec) {
                    return;
                }
                BitConfigField.this.sendValue(field, BitConfigField.this.view.isSelected() ? "1" : "0");
            }
        });
    }

    private void setValue(boolean value) {
        this.ec = true;
        this.view.setEnabled(true);
        this.view.setSelected(value);
        this.onValueArrived();
        this.ec = false;
    }

    @Override
    protected void loadValue(ConfigurationImage ci) {
        int bits = this.getByteBuffer(ci).getInt();
        boolean bit = (bits >> this.field.getBitOffset() & 1) == 1;
        this.setValue(bit);
    }
}

