/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.rusefi.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.ui.config.BaseConfigField;
import com.rusefi.ui.util.JTextFieldWithWidth;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ConfigField
extends BaseConfigField {
    private final JTextField view = new JTextFieldWithWidth(200);
    private static final DecimalFormat df = new DecimalFormat("0.0000");

    public ConfigField(final Field field, String topLabel) {
        super(field);
        this.createUi(topLabel, this.view);
        this.requestInitialValue(field);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                Pair<Integer, ?> p;
                if ((Field.isIntValueMessage(message) || Field.isFloatValueMessage(message)) && (p = Field.parseResponse(message)) != null && ((Integer)p.first).intValue() == field.getOffset()) {
                    Object value = p.second;
                    ConfigField.this.setValue(value);
                }
            }
        });
        this.view.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ConfigField.this.sendValue(field, ConfigField.this.view.getText());
                }
            }
        });
    }

    private void setValue(Object value) {
        this.view.setEnabled(true);
        this.view.setText("" + value);
        this.onValueArrived();
    }

    @Override
    protected void loadValue(ConfigurationImage ci) {
        Number value = ConfigField.getValue(ci, this.field);
        this.setValue(value);
    }

    @NotNull
    public static Number getValue(ConfigurationImage ci, Field field) {
        ByteBuffer wrapped = ConfigField.getByteBuffer(ci, field);
        Number value = field.getType() == FieldType.INT ? (Number)wrapped.getInt() : (Number)Float.valueOf(wrapped.getFloat());
        return value;
    }

    public static double getFloatValue(ConfigurationImage ci, Field field) {
        float value = ConfigField.getValue(ci, field).floatValue();
        String str = df.format(value);
        try {
            return df.parse(str).doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalStateException("While parsing [" + str + "]");
        }
    }

    public static int getIntValue(ConfigurationImage ci, Field field) {
        return ConfigField.getValue(ci, field).intValue();
    }
}

