/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.rusefi.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.ui.config.BaseConfigField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public class EnumConfigField
extends BaseConfigField {
    private final JComboBox<String> view = new JComboBox();
    private boolean ec;
    private final Map<String, Integer> ordinals = new HashMap<String, Integer>();
    private final String[] options = this.field.getOptions();

    public EnumConfigField(final Field field, String caption) {
        super(field);
        if (this.options == null) {
            throw new NullPointerException("options for " + field);
        }
        this.createUi(caption, this.view);
        int ordinal = 0;
        for (String option : this.options) {
            this.ordinals.put(option, ordinal++);
            if ("invalid".equalsIgnoreCase(option)) continue;
            this.view.addItem(option);
        }
        this.requestInitialValue(field);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                Pair<Integer, ?> p;
                if (Field.isIntValueMessage(message) && (p = Field.parseResponse(message)) != null && ((Integer)p.first).intValue() == field.getOffset()) {
                    int ordinal = (Integer)p.second;
                    EnumConfigField.this.setValue(ordinal);
                }
            }
        });
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EnumConfigField.this.ec) {
                    return;
                }
                String value = (String)EnumConfigField.this.view.getSelectedItem();
                int ordinal = (Integer)EnumConfigField.this.ordinals.get(value);
                EnumConfigField.this.sendValue(field, Integer.toString(ordinal));
            }
        });
    }

    private void setValue(int ordinal) {
        String item;
        if (ordinal >= this.options.length) {
            item = "unexpected_" + ordinal;
            this.view.addItem(item);
        } else {
            item = this.options[ordinal];
        }
        this.ec = true;
        this.view.setEnabled(true);
        this.view.setSelectedItem(item);
        this.onValueArrived();
        this.ec = false;
    }

    @Override
    protected void loadValue(ConfigurationImage ci) {
        int ordinal = this.getByteBuffer(ci).getInt();
        this.setValue(ordinal);
    }
}

