/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.rusefi.ui.config.DialogModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IniFileModel {
    private static final String FILENAME = "rusefi.ini";
    private static final IniFileModel INSTANCE = new IniFileModel();
    private String dialogId;
    private String dialogUiName;
    private List<DialogModel.Field> fields = new ArrayList<DialogModel.Field>();
    private Map<String, DialogModel> dialogs = new TreeMap<String, DialogModel>();

    public static void main(String[] args) {
        System.out.println(IniFileModel.INSTANCE.dialogs);
    }

    private IniFileModel() {
        this.readIniFile();
    }

    private void readIniFile() {
        File input = new File(FILENAME);
        BufferedReader d = null;
        try {
            d = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
        }
        catch (FileNotFoundException e) {
            System.out.println("No such file: rusefi.ini");
            return;
        }
        try {
            String line;
            State state = State.SKIPPING;
            while ((line = d.readLine()) != null) {
                this.handleLine(line);
            }
            this.finishDialog();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void finishDialog() {
        if (this.fields.isEmpty()) {
            return;
        }
        if (this.dialogUiName == null) {
            throw new NullPointerException("dialogUiName for" + this.fields);
        }
        this.dialogs.put(this.dialogUiName, new DialogModel(this.dialogId, this.dialogUiName, this.fields));
        this.dialogId = null;
        this.fields.clear();
    }

    private void handleLine(String line) {
        try {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(IniFileModel.split(line)));
            this.trim(list);
            if (list.isEmpty()) {
                return;
            }
            String first = list.getFirst();
            if ("dialog".equals(first)) {
                this.handleDialog(list);
            } else if ("field".equals(first)) {
                this.handleField(list);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("While [" + line + "]", e);
        }
    }

    private void handleField(LinkedList<String> list) {
        list.removeFirst();
        String uiLabel = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.fields.add(new DialogModel.Field(key, uiLabel));
        System.out.println("Field label=[" + uiLabel + "] : key=[" + key + "]");
    }

    private void handleDialog(LinkedList<String> list) {
        this.finishDialog();
        list.removeFirst();
        State state = State.DIALOG;
        String keyword = list.removeFirst();
        String name = list.isEmpty() ? null : list.removeFirst();
        this.dialogId = keyword;
        this.dialogUiName = name;
        System.out.println("Dialog key=" + keyword + ": name=[" + name + "]");
    }

    private void trim(LinkedList<String> list) {
        while (!list.isEmpty() && list.getFirst().isEmpty()) {
            list.removeFirst();
        }
    }

    public static String[] split(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        boolean inQuote = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || IniFileModel.isWhitespace(c) && !inQuote) {
                if (c == '\"') {
                    boolean bl = inQuote = !inQuote;
                }
                if (inQuote || sb.length() <= 0) continue;
                strings.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 61 || c == 44;
    }

    public static IniFileModel getinstance() {
        return INSTANCE;
    }

    public Map<String, DialogModel> getDialogs() {
        return this.dialogs;
    }

    static enum State {
        SKIPPING,
        DIALOG;

    }
}

