/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.engine;

import com.rusefi.Launcher;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.engine.EngineSnifferPanel;
import com.rusefi.ui.engine.NameUtil;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.waves.EngineReport;
import com.rusefi.waves.RevolutionLog;
import com.rusefi.waves.TimeAxisTranslator;
import com.rusefi.waves.ZoomProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.Timer;

public class UpDownImage
extends JPanel {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final int LINE_SIZE = 20;
    public static final Color TIME_SCALE_COLOR = Color.red;
    public static final Color ENGINE_CYCLE_COLOR = Color.green;
    private long lastUpdateTime;
    private EngineReport wr;
    private StringBuilder revolutions;
    private final String name;
    private TimeAxisTranslator translator;
    private RevolutionLog time2rpm = RevolutionLog.parseRevolutions(null);
    private String pin = "";
    private long mouseEnterTime;
    private Color signalBody = Color.lightGray;
    private Color signalBorder = Color.blue;
    private final Timer repaintTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UiUtils.trueRepaint(UpDownImage.this);
        }
    });
    public boolean showMouseOverText = true;
    private int currentMouseX = -100;
    private static final BasicStroke LONG_STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{21.0f, 7.0f}, 0.0f);

    public UpDownImage(String name) {
        this(EngineReport.MOCK, name);
        String pin;
        this.setToolTip();
        EngineSnifferPanel p = Launcher.engineSnifferPanel;
        if (p != null && (pin = p.channelName2PhysicalPin.get(name)) != null) {
            this.setPhysicalPin(pin);
        }
    }

    public void setSignalBody(Color signalBody) {
        this.signalBody = signalBody;
    }

    public void setSignalBorder(Color signalBorder) {
        this.signalBorder = signalBorder;
    }

    public void setToolTip() {
        UiUtils.setTwoLineToolTip(this, "Channel " + NameUtil.getUiName(this.name), "Physical pin: " + this.pin);
    }

    public void setZoomProvider(ZoomProvider zoomProvider) {
    }

    public UpDownImage(EngineReport wr, String name) {
        this.name = name;
        this.setWaveReport(wr, null);
        this.setOpaque(true);
        this.translator = this.createTranslator();
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                UpDownImage.this.currentMouseX = e.getX();
                UiUtils.trueRepaint(UpDownImage.this);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                UpDownImage.this.mouseEnterTime = System.currentTimeMillis();
                UiUtils.trueRepaint(UpDownImage.this);
                UpDownImage.this.repaintTimer.restart();
            }
        });
    }

    public UpDownImage setTranslator(TimeAxisTranslator translator) {
        this.translator = translator;
        return this;
    }

    public TimeAxisTranslator createTranslator() {
        return new TimeAxisTranslator(){

            @Override
            public int timeToScreen(int time, int width) {
                return UpDownImage.this.wr.timeToScreen(time, width);
            }

            @Override
            public double screenToTime(int screen, int width) {
                return UpDownImage.this.wr.screenToTime(screen, width);
            }

            @Override
            public int getMaxTime() {
                return UpDownImage.this.wr.getMaxTime();
            }

            @Override
            public int getMinTime() {
                return UpDownImage.this.wr.getMinTime();
            }

            public String toString() {
                return "TimeAxisTranslator";
            }
        };
    }

    public void setWaveReport(EngineReport wr, StringBuilder revolutions) {
        this.wr = wr;
        this.propagateDwellIntoSensor(wr);
        this.revolutions = revolutions;
        this.lastUpdateTime = System.currentTimeMillis();
        UiUtils.trueRepaint(this);
    }

    private void propagateDwellIntoSensor(EngineReport wr) {
        Sensor sensor = NameUtil.name2sensor.get(this.name);
        if (sensor == null) {
            return;
        }
        if (!wr.getList().isEmpty()) {
            EngineReport.UpDown last = wr.getList().get(wr.getList().size() - 1);
            SensorCentral.getInstance().setValue(last.getDuration(), sensor);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        for (EngineReport.UpDown upDown : this.wr.getList()) {
            this.paintUpDown(d, upDown, g);
        }
        if (this.showMouseOverText) {
            this.paintScaleLines(g2, d);
        }
        int duration = this.wr.getDuration();
        g2.setColor(Color.black);
        int line = 0;
        boolean justEntered = System.currentTimeMillis() - this.mouseEnterTime < 1000L;
        Font f = this.getFont();
        if (justEntered) {
            g.setFont(f.deriveFont(1, f.getSize() * 3));
            g.setColor(Color.red);
        }
        if (this.showMouseOverText) {
            String mouseOverText = NameUtil.getUiName(this.name);
            if (this.pin != null) {
                mouseOverText = mouseOverText + "/" + this.pin;
            }
            g.drawString(mouseOverText, 5, ++line * 20 + (justEntered ? 30 : 0));
        }
        if (justEntered) {
            g.setFont(f);
            g.setColor(Color.black);
        }
        if (this.showMouseOverText) {
            g.drawString("Tick length: " + duration + "; count=" + this.wr.getList().size(), 5, ++line * 20);
            g.drawString("Total seconds: " + (double)duration / 100.0 / 0.0, 5, ++line * 20);
            g.drawString(FORMAT.format(new Date(this.lastUpdateTime)), 5, ++line * 20);
        }
        this.drawStartOfRevolution(g2, d);
    }

    private void drawStartOfRevolution(Graphics2D g2, Dimension d) {
        if (this.revolutions == null) {
            return;
        }
        RevolutionLog time2rpm = RevolutionLog.parseRevolutions(this.revolutions);
        g2.setStroke(new BasicStroke());
        for (int time : time2rpm.keySet()) {
            int x = this.translator.timeToScreen(time, d.width);
            g2.setColor(ENGINE_CYCLE_COLOR);
            g2.drawLine(x, 0, x, d.height);
            if (!this.isShowTdcLabel()) continue;
            g2.rotate(1.5707963267948966);
            g2.drawString("#1 TDC", 0, -x - 3);
            g2.rotate(-1.5707963267948966);
        }
    }

    protected boolean isShowTdcLabel() {
        return false;
    }

    private void paintScaleLines(Graphics2D g2, Dimension d) {
        int fromMs = this.translator.getMinTime() / 10000;
        g2.setStroke(LONG_STROKE);
        g2.setColor(TIME_SCALE_COLOR);
        int toMs = this.translator.getMaxTime() / 10000;
        if ((double)(toMs - fromMs) > d.getWidth() / 5.0) {
            return;
        }
        for (int ms = fromMs; ms <= toMs; ++ms) {
            int tick = ms * 10000;
            int x = this.translator.timeToScreen(tick, d.width);
            g2.drawLine(x, 0, x, d.height);
        }
    }

    private void paintUpDown(Dimension d, EngineReport.UpDown upDown, Graphics g) {
        int x1 = this.translator.timeToScreen(upDown.upTime, d.width);
        int x2 = this.translator.timeToScreen(upDown.downTime, d.width);
        int y = (int)(0.2 * (double)d.height);
        g.setColor(this.signalBody);
        g.fillRect(x1, y, x2 - x1, d.height - y);
        g.setColor(this.signalBorder);
        g.drawLine(x1, y, x2, y);
        g.drawLine(x1, y, x1, d.height);
        g.drawLine(x2, y, x2, d.height);
        g.setColor(Color.red);
        String durationString = String.format(" %.2fms", (double)upDown.getDuration() / 100.0);
        if (this.showMouseOverText) {
            g.drawString(durationString, x1, (int)(0.5 * (double)d.height));
            double fromAngle = this.time2rpm.getCrankAngleByTime(upDown.upTime);
            double toAngle = this.time2rpm.getCrankAngleByTime(upDown.downTime);
            String fromAngleStr = RevolutionLog.angle2string(fromAngle);
            g.setColor(Color.darkGray);
            if (upDown.upIndex != -1) {
                g.drawString("" + upDown.upIndex, x1, (int)(0.25 * (double)d.height));
            }
            if (upDown.downIndex != -1) {
                g.drawString("" + upDown.downIndex, x2, (int)(0.25 * (double)d.height));
            }
            int offset = 3;
            g.setColor(Color.black);
            g.drawString(fromAngleStr, x1 + offset, (int)(0.75 * (double)d.height));
            g.setColor(Color.black);
            if (Math.abs(x1 - this.currentMouseX) < 5) {
                double angleDuration = toAngle - fromAngle;
                String durationStr = RevolutionLog.angle2string(angleDuration);
                g.drawString(durationStr, x1 + offset, (int)(1.0 * (double)d.height));
            } else {
                String toAngleStr = RevolutionLog.angle2string(toAngle);
                g.drawString(toAngleStr, x1 + offset, (int)(1.0 * (double)d.height));
            }
        }
    }

    public void setRevolutions(StringBuilder revolutions) {
        this.time2rpm = RevolutionLog.parseRevolutions(revolutions);
    }

    public void setPhysicalPin(String pin) {
        this.pin = pin;
        this.setToolTip();
    }

    @Override
    public String toString() {
        return "UpDownImage{} " + super.toString();
    }
}

