/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.engine;

import com.rusefi.KeyStrokeShortcut;
import com.rusefi.waves.ZoomProvider;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class ZoomControl
extends JPanel {
    private double value;
    public ZoomControlListener listener = null;
    private final JButton resetZoom = new JButton("*");
    private ZoomProvider zoomProvider = new ZoomProvider(){

        @Override
        public double getZoomValue() {
            return ZoomControl.this.value;
        }

        public String toString() {
            return "zoom " + ZoomControl.this.value;
        }
    };

    public ZoomControl() {
        super(new FlowLayout());
        this.setValue(1.0);
        JButton plus = new JButton("+");
        plus.setMnemonic('z');
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomControl.this.zoomIn();
            }
        });
        plus.setToolTipText("Zoom in");
        this.add(plus);
        this.resetZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomControl.this.setValue(1.0);
            }
        });
        this.resetZoom.setToolTipText("Reset zoom");
        this.add(this.resetZoom);
        JButton minus = new JButton("-");
        plus.setMnemonic('x');
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomControl.this.zoomOut();
            }
        });
        minus.setToolTipText("Zoom out");
        this.add(minus);
        this.bindKeyStrokeActions();
    }

    private void bindKeyStrokeActions() {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(107, 0), (Object)KeyStrokeShortcut.ZOOM_IN);
        inputMap.put(KeyStroke.getKeyStroke(109, 0), (Object)KeyStrokeShortcut.ZOOM_OUT);
        this.getActionMap().put((Object)KeyStrokeShortcut.ZOOM_IN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ZoomControl.this.zoomIn();
            }
        });
        this.getActionMap().put((Object)KeyStrokeShortcut.ZOOM_OUT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ZoomControl.this.zoomOut();
            }
        });
    }

    private void zoomIn() {
        this.setValue(this.value * 1.1);
    }

    private void zoomOut() {
        this.setValue(this.value / 1.1);
    }

    private void setValue(double value) {
        System.out.println("Zoom setValue " + value);
        this.value = value;
        this.resetZoom.setEnabled(Math.abs(1.0 - value) > 0.01);
        if (this.listener != null) {
            this.listener.onZoomChange();
        }
    }

    public ZoomProvider getZoomProvider() {
        return this.zoomProvider;
    }

    static interface ZoomControlListener {
        public void onZoomChange();
    }
}

