/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.storage;

import com.rusefi.FileLog;
import com.rusefi.ui.storage.Node;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class PersistentConfiguration {
    private static final PersistentConfiguration INSTANCE = new PersistentConfiguration();
    private static final String CONFIG_FILE_NAME = "rusefi_console_properties.xml";
    private Map<String, Object> config = new HashMap<String, Object>();

    public static PersistentConfiguration getConfig() {
        return INSTANCE;
    }

    public void load() {
        try {
            XMLDecoder e = new XMLDecoder(new BufferedInputStream(new FileInputStream(CONFIG_FILE_NAME)));
            this.config = (Map)e.readObject();
            e.close();
        }
        catch (Throwable e) {
            FileLog.MAIN.logLine("Console configuration not found rusefi_console_properties.xml, using defaults");
        }
    }

    public void save() {
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(CONFIG_FILE_NAME)));
            e.writeObject(this.config);
            e.close();
            System.out.println("Saved to rusefi_console_properties.xml");
        }
        catch (FileNotFoundException e1) {
            FileLog.MAIN.logLine("Error saving rusefi_console_properties.xml");
        }
    }

    public Node getRoot() {
        return new Node("root", this.config);
    }
}

