/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.rusefi.FileLog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FrameHelper {
    protected final JFrame frame = new JFrame();
    public static int defaultFontSize;

    public JFrame getFrame() {
        return this.frame;
    }

    public void showFrame(JComponent component) {
        this.showFrame(component, true);
    }

    public void showFrame(JComponent component, boolean maximizeOnStart) {
        this.initFrame(component, maximizeOnStart);
        this.frame.setVisible(true);
    }

    public void initFrame(JComponent component, final boolean maximizeOnStart) {
        this.frame.setSize(800, 500);
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrameHelper.this.onWindowOpened();
                if (maximizeOnStart) {
                    FrameHelper.this.frame.setExtendedState(FrameHelper.this.frame.getExtendedState() | 6);
                }
            }

            @Override
            public void windowClosed(WindowEvent ev) {
                FrameHelper.this.onWindowClosed();
            }
        });
        this.frame.add(component);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                defaultFontSize = FrameHelper.this.frame.getFont().getSize();
            }
        });
    }

    protected void onWindowOpened() {
        FileLog.MAIN.logLine("onWindowOpened");
    }

    protected void onWindowClosed() {
        FileLog.MAIN.logLine("onWindowClosed");
        FileLog.MAIN.close();
    }

    public int getDefaultFontSize() {
        return defaultFontSize;
    }
}

