/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.rusefi.StartupFrame;
import com.rusefi.ui.util.LocalizedMessages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.NotNull;

public class UiUtils {
    private static final String SAVE_IMAGE = "save image";

    public static void saveImageWithPrompt(String fileName, Component parentForDialog, Component content) {
        JFileChooser fc = UiUtils.getFileChooser(new FileNameExtensionFilter("PNG files", "png"));
        fc.setSelectedFile(new File(fileName));
        if (fc.showSaveDialog(parentForDialog) == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
            UiUtils.saveImage(fileName, content);
        }
    }

    @NotNull
    public static JFileChooser getFileChooser(FileNameExtensionFilter filter) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        return fc;
    }

    public static void saveImage(String fileName, Component component) {
        BufferedImage img = UiUtils.getScreenShot(component);
        try {
            ImageIO.write((RenderedImage)img, "png", new File(fileName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static BufferedImage getScreenShot(Component component) {
        BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        component.paint(image.getGraphics());
        return image;
    }

    public static void setPauseButtonText(JButton pauseButton, boolean isPaused) {
        pauseButton.setText(isPaused ? LocalizedMessages.RESUME.getMessage() : LocalizedMessages.PAUSE.getMessage());
    }

    public static void centerWindow(Window w) {
        w.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = w.getSize();
        w.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void trueRepaint(JComponent control) {
        control.invalidate();
        control.repaint();
    }

    public static void trueRepaint(Container control) {
        UiUtils.trueLayout(control);
    }

    public static void trueLayout(Component component) {
        if (component == null) {
            return;
        }
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public static void setTwoLineToolTip(JComponent component, String line1, String line2) {
        component.setToolTipText("<html>" + line1 + "<br>" + line2 + "</html>");
    }

    public static JComponent wrap(JComponent component) {
        JPanel result = new JPanel();
        result.add(component);
        return result;
    }

    public static JButton createSaveImageButton() {
        JButton imageButton = new JButton(SAVE_IMAGE);
        imageButton.setMnemonic('s');
        return imageButton;
    }

    public static ImageIcon loadIcon(String strPath) {
        URL imgURL = StartupFrame.class.getResource(strPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void showLoadingMessage(JPanel panel) {
        panel.add((Component)new JLabel("Loading..."), "Center");
    }

    @NotNull
    public static JButton createPauseButton() {
        JButton pauseButton = new JButton(LocalizedMessages.PAUSE.getMessage());
        pauseButton.setMnemonic('p');
        return pauseButton;
    }

    @NotNull
    public static JButton createClearButton() {
        JButton clearButton = new JButton(LocalizedMessages.CLEAR.getMessage());
        clearButton.setMnemonic('c');
        return clearButton;
    }
}

