/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.io.CommandQueue;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.storage.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class AnyCommand {
    public static final String KEY = "last_value";
    private final JTextComponent text;
    private JPanel content = new JPanel(new FlowLayout(0));
    private boolean reentrant;
    private Listener listener;

    private AnyCommand(final JTextComponent text, final Node config, String defaultCommand, final boolean listenToCommands, boolean withCommandCaption) {
        this.text = text;
        text.setText(defaultCommand);
        this.content.setBorder(BorderFactory.createLineBorder(Color.PINK));
        if (withCommandCaption) {
            this.content.add(new JLabel("Command: "));
        }
        this.content.add(text);
        JButton go = new JButton("Go");
        go.setContentAreaFilled(false);
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnyCommand.this.send();
            }
        });
        this.content.add(go);
        CommandQueue.getInstance().addListener(new CommandQueue.CommandQueueListener(){

            @Override
            public void onCommand(String command) {
                if (listenToCommands && !AnyCommand.this.reentrant) {
                    text.setText(command);
                }
            }
        });
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                boolean isOk = AnyCommand.isValidInput(text.getText());
                text.setBorder(isOk ? null : BorderFactory.createLineBorder(Color.red));
                config.setProperty(AnyCommand.KEY, text.getText());
            }
        });
    }

    private void send() {
        String cmd = this.text.getText();
        for (String s : cmd.split("\n")) {
            this.doSend(s);
        }
    }

    private void doSend(String cmd) {
        if (!AnyCommand.isValidInput(cmd)) {
            return;
        }
        if (this.listener != null) {
            this.listener.onSend();
        }
        int timeout = CommandQueue.getTimeout(cmd);
        this.reentrant = true;
        CommandQueue.getInstance().write(cmd.toLowerCase(), timeout);
        this.reentrant = false;
    }

    private static boolean isValidInput(String text) {
        boolean isOk = true;
        for (char c : text.toCharArray()) {
            if (c <= '\u007f') continue;
            isOk = false;
            break;
        }
        return isOk;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setContent(JPanel content) {
        this.content = content;
    }

    public static AnyCommand createField(Node config, boolean listenToCommands, boolean withCommandCaption) {
        return AnyCommand.createField(config, config.getProperty(KEY), listenToCommands, withCommandCaption);
    }

    public static AnyCommand createField(Node config, String defaultCommand, boolean listenToCommands, boolean withCommandCaption) {
        final JTextField text = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(200, size.height);
            }
        };
        final AnyCommand command = new AnyCommand(text, config, defaultCommand, listenToCommands, withCommandCaption);
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.send();
            }
        });
        final AtomicInteger index = new AtomicInteger();
        command.listener = new Listener(){

            @Override
            public void onSend() {
                index.set(0);
            }
        };
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    String command = RecentCommands.getRecent(index.incrementAndGet());
                    text.setText(command);
                } else if (e.getKeyCode() == 40) {
                    String command = RecentCommands.getRecent(index.decrementAndGet());
                    text.setText(command);
                }
            }
        });
        return command;
    }

    public static AnyCommand createArea(Node config, String defaultCommand, boolean listenToCommands, boolean withCommandCaption) {
        JTextArea text = new JTextArea(3, 20){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(200, size.height);
            }
        };
        return new AnyCommand(text, config, defaultCommand, listenToCommands, withCommandCaption);
    }

    static interface Listener {
        public void onSend();
    }
}

