/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class BooleanFlagControlPanel {
    private final JPanel content = new JPanel(new MigLayout());
    protected final JCheckBox checkBox;

    public BooleanFlagControlPanel(String labelCaption, String checkboxCaption) {
        this.content.add(new JLabel(labelCaption));
        this.checkBox = new JCheckBox(checkboxCaption);
        this.content.add(this.checkBox);
    }

    public JComponent getControl() {
        return this.content;
    }

    protected void installCommand(final String command) {
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mode = BooleanFlagControlPanel.this.checkBox.isSelected() ? 1 : 0;
                CommandQueue.getInstance().write(command + mode);
            }
        });
    }

    protected void installStatusReader(Sensor statusSensor) {
        SensorCentral.getInstance().addListener(statusSensor, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                BooleanFlagControlPanel.this.checkBox.setSelected(value > 0.0);
            }
        });
    }
}

