/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.core.Sensor;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.GaugesPanel;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.SensorGauge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetachedSensor {
    private static final String NAME = "name";
    private static final String WIDTH = "width";
    private static final Collection<Sensor> MOCKABLE = Arrays.asList(Sensor.CLT, Sensor.AFR, Sensor.IAT, Sensor.MAF, Sensor.TPS);
    private static final Hashtable<Integer, JComponent> SLIDER_LABELS = new Hashtable();
    public static final String XPOS = "xpos";
    public static final String YPOS = "ypos";
    private static final int _5_VOLTS_WITH_DECIMAL = 50;
    private final JPanel content = new JPanel(new BorderLayout());
    private final JFrame frame;
    private final JPanel mockControlPanel = new JPanel(new BorderLayout());
    private Sensor sensor;
    private int width;

    public DetachedSensor(Sensor sensor, int width) {
        this.width = width;
        this.frame = new JFrame();
        this.frame.setAlwaysOnTop(true);
        this.onChange(sensor);
        GaugesPanel.DetachedRepository.INSTANCE.add(this);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GaugesPanel.DetachedRepository.INSTANCE.remove(DetachedSensor.this);
                DetachedSensor.this.frame.dispose();
            }
        });
        this.create();
    }

    void create() {
        SensorGauge.GaugeChangeListener listener = new SensorGauge.GaugeChangeListener(){

            @Override
            public void onSensorChange(Sensor sensor) {
                DetachedSensor.this.onChange(sensor);
            }
        };
        this.content.add(SensorGauge.createGauge(this.sensor, listener, null), "Center");
        this.content.add((Component)this.mockControlPanel, "South");
        this.frame.add(this.content);
    }

    public void show(MouseEvent e) {
        this.frame.setVisible(true);
        this.frame.setLocation(e.getXOnScreen(), e.getYOnScreen());
    }

    public void onChange(Sensor sensor) {
        this.sensor = sensor;
        this.frame.setTitle(sensor.getName());
        this.showMockControl();
    }

    public void showMockControl() {
        this.mockControlPanel.removeAll();
        boolean isMockable = this.isMockable();
        if (isMockable) {
            Component mockComponent = DetachedSensor.createMockVoltageSlider(this.sensor);
            this.mockControlPanel.add(mockComponent);
        }
        UiUtils.trueLayout(this.content);
        int size = this.width;
        int h = isMockable ? (int)((double)size * 1.5) : size;
        this.frame.setSize(size, h);
    }

    private boolean isMockable() {
        return MOCKABLE.contains((Object)this.sensor) && LinkManager.isStimulationMode;
    }

    private static Component createMockVoltageSlider(final Sensor sensor) {
        final JSlider slider = new JSlider(0, 50);
        slider.setLabelTable(SLIDER_LABELS);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(5);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double value = (double)slider.getValue() / 10.0;
                CommandQueue.getInstance().write("set_mock_" + sensor.name().toLowerCase() + "_voltage " + value);
            }
        });
        return slider;
    }

    public void saveConfig(Node child) {
        child.setProperty(NAME, this.sensor.name());
        child.setProperty(WIDTH, this.frame.getWidth());
        child.setProperty(XPOS, this.frame.getLocation().x);
        child.setProperty(YPOS, this.frame.getLocation().y);
    }

    public static void create(Node child) {
        Sensor sensor = Sensor.lookup(child.getProperty(NAME, Sensor.RPM.name()), Sensor.RPM);
        int width = child.getIntProperty(WIDTH, 256);
        int xpos = child.getIntProperty(XPOS, 0);
        int ypos = child.getIntProperty(YPOS, 0);
        DetachedSensor ds = new DetachedSensor(sensor, width);
        ds.frame.setLocation(xpos, ypos);
        ds.frame.setVisible(true);
    }

    static {
        DecimalFormat f = new DecimalFormat("0.0");
        for (int i = 0; i <= 50; i += 5) {
            JLabel label = new JLabel(f.format((Object)((double)i * 0.1)));
            label.setFont(label.getFont().deriveFont(0));
            SLIDER_LABELS.put(i, label);
        }
    }
}

