/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.EcuStimulator;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PotCommand {
    public static final double VOLTAGE_CORRECTION = 0.9666666666666667;
    public final JPanel panel;
    final JSpinner potSpinner;

    public PotCommand(final int channel) {
        final JLabel rValue = new JLabel();
        final JSpinner voltageSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1)){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(100, size.height);
            }
        };
        ((SpinnerNumberModel)voltageSpinner.getModel()).setStepSize(0.1);
        voltageSpinner.setValue(1.0);
        voltageSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double Vout = (Double)voltageSpinner.getValue();
                int d = PotCommand.getPotResistance(Vout, SensorCentral.getInstance().getValue(Sensor.VREF) * 0.9666666666666667);
                PotCommand.this.potSpinner.setValue(d);
            }
        });
        this.potSpinner = new JSpinner(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(100, size.height);
            }
        };
        this.potSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer value = (Integer)PotCommand.this.potSpinner.getValue();
                try {
                    PotCommand.requestPotChange(channel, value);
                }
                catch (IllegalArgumentException ignore) {
                    return;
                }
                int r = PotCommand.getRbyD(value);
                rValue.setText("R=" + r);
            }
        });
        this.potSpinner.setValue(10);
        JPanel upper = new JPanel(new FlowLayout(0));
        upper.add(new JLabel("set pot" + channel + ": "));
        upper.add(this.potSpinner);
        upper.add(rValue);
        JPanel center = new JPanel(new FlowLayout(0));
        center.add(new JLabel("volts: "));
        center.add(voltageSpinner);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(BorderFactory.createLineBorder(Color.CYAN));
        this.panel.add((Component)upper, "North");
        this.panel.add((Component)center, "Center");
    }

    public static void requestPotChange(int channel, int resistance) {
        if (resistance < 0 || resistance > 10000) {
            throw new IllegalArgumentException("resistance: " + resistance);
        }
        CommandQueue.getInstance().write("pot " + channel + " " + resistance);
    }

    public static int getPotResistance(double vout, double vRef) {
        double r = PotCommand.getR1InVoltageDivider3(vout, vRef, EcuStimulator.getInstance().getInputs().getEngineLoadR2Resistance());
        MessagesCentral.getInstance().postMessage(PotCommand.class, "VRef=" + vRef + ", needed resistance: " + r);
        return (int)r;
    }

    private static int getRbyD(Integer value) {
        return (int)(10000.0 * (double)(256 - value) / 256.0) + 52;
    }

    public static double getR1InVoltageDivider3(double Vout, double Vin, double r2) {
        return r2 * Vout / Vin;
    }
}

