/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCategory;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.GaugesPanel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.DetachedSensor;
import com.rusefi.ui.widgets.JPanelWithListener;
import eu.hansolo.steelseries.gauges.Radial;
import eu.hansolo.steelseries.tools.ColorDef;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SensorGauge {
    private static final String HINT_LINE_1 = "Double-click to detach";
    private static final String HINT_LINE_2 = "Right-click to change";

    public static Component createGauge(Sensor sensor, GaugeChangeListener listener, JMenuItem extraMenuItem) {
        JPanelWithListener wrapper = new JPanelWithListener(new BorderLayout());
        SensorGauge.createGaugeBody(sensor, wrapper, listener, extraMenuItem);
        return wrapper;
    }

    public static void createGaugeBody(final Sensor sensor, final JPanelWithListener wrapper, final GaugeChangeListener listener, final JMenuItem extraMenuItem) {
        final Radial gauge = SensorGauge.createRadial(sensor.getName(), sensor.getUnits(), sensor.getMaxValue(), sensor.getMinValue());
        UiUtils.setTwoLineToolTip(gauge, HINT_LINE_1, HINT_LINE_2);
        UiUtils.setTwoLineToolTip(wrapper, HINT_LINE_1, HINT_LINE_2);
        gauge.setBackgroundColor(sensor.getColor());
        SensorCentral.getInstance().addListener(sensor, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                if (GaugesPanel.IS_PAUSED) {
                    return;
                }
                gauge.setValue(sensor.translateValue(value));
            }
        });
        gauge.setValue(sensor.translateValue(SensorCentral.getInstance().getValue(sensor)));
        gauge.setLcdDecimals(2);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    SensorGauge.showPopupMenu(e, wrapper, listener, extraMenuItem);
                } else if (e.getClickCount() == 2) {
                    SensorGauge.handleDoubleClick(e, gauge, sensor);
                }
            }
        };
        gauge.addMouseListener(mouseListener);
        wrapper.removeAllChildrenAndListeners();
        wrapper.addMouseListener(mouseListener);
        wrapper.add((Component)gauge, "Center");
        UiUtils.trueRepaint(wrapper.getParent());
        UiUtils.trueLayout(wrapper.getParent());
    }

    private static void showPopupMenu(MouseEvent e, JPanelWithListener wrapper, GaugeChangeListener listener, JMenuItem extraMenuItem) {
        JPopupMenu pm = new JPopupMenu();
        SensorGauge.fillGaugeMenuItems(pm, wrapper, listener, extraMenuItem);
        if (extraMenuItem != null) {
            pm.add(extraMenuItem);
        }
        pm.show(e.getComponent(), e.getX(), e.getY());
    }

    private static void fillGaugeMenuItems(JPopupMenu popupMenu, final JPanelWithListener wrapper, final GaugeChangeListener listener, final JMenuItem extraMenuItem) {
        for (SensorCategory sc : SensorCategory.values()) {
            JMenu cmi = new JMenu(sc.getName());
            popupMenu.add(cmi);
            for (final Sensor s : Sensor.getSensorsForCategory(sc.getName())) {
                JMenuItem mi = new JMenuItem(s.getName());
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SensorGauge.createGaugeBody(s, wrapper, listener, extraMenuItem);
                        listener.onSensorChange(s);
                    }
                });
                ((Container)cmi).add(mi);
            }
        }
    }

    private static void handleDoubleClick(MouseEvent e, Radial gauge, Sensor sensor) {
        int width = gauge.getSize().width;
        DetachedSensor ds = new DetachedSensor(sensor, width);
        ds.show(e);
    }

    public static Radial createRadial(String title, String units, double maxValue, double minValue) {
        Radial radial1 = new Radial();
        radial1.setTitle(title);
        radial1.setUnitString(units);
        radial1.setMinValue(minValue);
        radial1.setMaxValue(maxValue);
        radial1.setThresholdVisible(false);
        radial1.setPointerColor(ColorDef.RED);
        radial1.setValue(0.0);
        return radial1;
    }

    public static interface GaugeChangeListener {
        public void onSensorChange(Sensor var1);
    }
}

