/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.PostPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class Compass
extends AbstractRadial {
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 360.0;
    private double value = 0.0;
    private double angleStep = Math.PI / 180;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage compassRoseImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage pointerImage;
    private BufferedImage disabledImage;
    private Timeline timeline = new Timeline(this);
    private final Spline EASE = new Spline(0.5f);

    public Compass() {
        this.setPointerColor(ColorDef.RED);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        if (this.compassRoseImage != null) {
            this.compassRoseImage.flush();
        }
        this.compassRoseImage = this.create_COMPASS_ROSE_Image(n4);
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(n4);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4);
        this.createPostsImage(n4, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        graphics2D.drawImage((Image)this.compassRoseImage, 0, 0, null);
        graphics2D.rotate((this.value - 0.0) * this.angleStep, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate((this.value - 0.0) * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double d) {
        if (this.isEnabled()) {
            double d2 = this.value;
            this.value = d % 360.0;
            this.fireStateChanged();
            this.firePropertyChange("value", d2, this.value);
            this.repaint();
        }
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            if (360.0 - d + this.value < d - this.value) {
                d = 360.0 - d;
            }
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.value, d);
            this.timeline.setEase(this.EASE);
            this.timeline.setDuration(250L);
            this.timeline.play();
        }
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BIG_ROSE_POINTER_Image(int n) {
        BufferedImage bufferedImage = UTIL.createImage((int)((float)n * 0.0546875f), (int)((float)n * 0.2f), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        graphics2D.setStroke(new BasicStroke(0.75f));
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath.moveTo((float)n2 - (float)n2 * 0.95f, n3);
        generalPath.lineTo((float)n2 / 2.0f, 0.0f);
        generalPath.lineTo((float)n2 / 2.0f, n3);
        generalPath.closePath();
        generalPath2.moveTo((float)n2 * 0.95f, n3);
        generalPath2.lineTo((float)n2 / 2.0f, 0.0f);
        generalPath2.lineTo((float)n2 / 2.0f, n3);
        generalPath2.closePath();
        Area area = new Area(generalPath);
        area.add(new Area(generalPath2));
        Color color = this.getBackgroundColor().SYMBOL_COLOR.darker();
        Color color2 = this.getBackgroundColor().SYMBOL_COLOR;
        graphics2D.setColor(color);
        graphics2D.fill(generalPath2);
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath);
        graphics2D.setColor(color);
        graphics2D.draw(area);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SMALL_ROSE_POINTER_Image(int n) {
        BufferedImage bufferedImage = UTIL.createImage((int)((float)n * 0.0546875f), (int)((float)n * 0.2f), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        graphics2D.setStroke(new BasicStroke(0.75f));
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath.moveTo((float)n2 - (float)n2 * 0.75f, n3);
        generalPath.lineTo((float)n2 / 2.0f, (float)n3 / 2.0f);
        generalPath.lineTo((float)n2 / 2.0f, n3);
        generalPath.closePath();
        generalPath2.moveTo((float)n2 * 0.75f, n3);
        generalPath2.lineTo((float)n2 / 2.0f, (float)n3 / 2.0f);
        generalPath2.lineTo((float)n2 / 2.0f, n3);
        generalPath2.closePath();
        Area area = new Area(generalPath);
        area.add(new Area(generalPath2));
        Color color = this.getBackgroundColor().SYMBOL_COLOR.darker();
        Color color2 = this.getBackgroundColor().SYMBOL_COLOR;
        graphics2D.setColor(color2);
        graphics2D.fill(area);
        graphics2D.setColor(color);
        graphics2D.draw(area);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_COMPASS_ROSE_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        Point2D.Double double_ = new Point2D.Double((float)n2 / 2.0f, (float)n2 / 2.0f);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setStroke(new BasicStroke((float)n2 * 0.01953125f, 0, 2));
        graphics2D.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        for (int i = 0; i <= 360; i += 30) {
            graphics2D.draw(new Arc2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.26367188f), ((Point2D)double_).getY() - (double)((float)n2 * 0.26367188f), (float)n2 * 0.52734375f, (float)n2 * 0.52734375f, i, 15.0, 0));
        }
        graphics2D.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        graphics2D.setStroke(new BasicStroke(0.5f));
        Ellipse2D.Double double_2 = new Ellipse2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.2734375f), ((Point2D)double_).getY() - (double)((float)n2 * 0.2734375f), (float)n2 * 0.546875f, (float)n2 * 0.546875f);
        graphics2D.draw(double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.25390625f), ((Point2D)double_).getY() - (double)((float)n2 * 0.25390625f), (float)n2 * 0.5078125f, (float)n2 * 0.5078125f);
        graphics2D.draw(double_3);
        Line2D.Double double_4 = new Line2D.Double(((Point2D)double_).getX(), (double)n2 * 0.4018691589, ((Point2D)double_).getX(), (double)n2 * 0.1495327103);
        graphics2D.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.5235987755982988, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.rotate(0.2617993877991494, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.draw(double_4);
        graphics2D.setTransform(affineTransform);
        BufferedImage bufferedImage2 = this.create_BIG_ROSE_POINTER_Image(n2);
        BufferedImage bufferedImage3 = this.create_SMALL_ROSE_POINTER_Image(n2);
        Point2D.Double double_5 = new Point2D.Double((float)n2 * 0.475f, (float)n2 * 0.2f);
        graphics2D.translate(((Point2D)double_5).getX(), ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
        graphics2D.rotate(0.7853981633974483, ((Point2D)double_).getX() - ((Point2D)double_5).getX(), ((Point2D)double_).getY() - ((Point2D)double_5).getY());
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, this);
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        graphics2D.setStroke(new BasicStroke((float)n2 * 0.00953125f, 0, 2));
        graphics2D.draw(new Ellipse2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.1025f), ((Point2D)double_).getY() - (double)((float)n2 * 0.1025f), (float)n2 * 0.205f, (float)n2 * 0.205f));
        graphics2D.setStroke(new BasicStroke(0.5f));
        graphics2D.setColor(this.getBackgroundColor().SYMBOL_COLOR.darker());
        Ellipse2D.Double double_6 = new Ellipse2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.11f), ((Point2D)double_).getY() - (double)((float)n2 * 0.11f), (float)n2 * 0.22f, (float)n2 * 0.22f);
        graphics2D.draw(double_6);
        Ellipse2D.Double double_7 = new Ellipse2D.Double(((Point2D)double_).getX() - (double)((float)n2 * 0.095f), ((Point2D)double_).getY() - (double)((float)n2 * 0.095f), (float)n2 * 0.19f, (float)n2 * 0.19f);
        graphics2D.draw(double_7);
        this.create_TICKMARKS(graphics2D, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void create_TICKMARKS(Graphics2D graphics2D, int n) {
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = new BasicStroke(0.005859375f * (float)n, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.00390625f * (float)n, 1, 2);
        Font font = new Font("Serif", 0, (int)(0.12f * (float)n));
        Font font2 = new Font("Serif", 0, (int)(0.06f * (float)n));
        float f = 0.075f * (float)n;
        float f2 = 0.015625f * (float)n;
        float f3 = 0.0234375f * (float)n;
        float f4 = 0.03125f * (float)n;
        Color color = this.getBackgroundColor().LABEL_COLOR;
        Color color2 = this.getBackgroundColor().LABEL_COLOR;
        float f5 = (float)n * 0.38f;
        Point2D.Double double_ = new Point2D.Double((float)n / 2.0f, (float)n / 2.0f);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Point2D.Double double_2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (double d3 = Math.PI * 2; d3 >= 0.0; d3 -= Math.PI / 180) {
            Line2D.Double double_3;
            Point2D.Double double_4;
            Point2D.Double double_5;
            graphics2D.setStroke(basicStroke2);
            d = Math.sin(d3);
            d2 = Math.cos(d3);
            graphics2D.setColor(color2);
            if (n4 == 5) {
                graphics2D.setStroke(basicStroke2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f2) * d, ((Point2D)double_).getY() + (double)(f5 - f2) * d2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d, ((Point2D)double_).getY() + (double)f5 * d2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n4 = 0;
            }
            if (n3 == 15) {
                graphics2D.setStroke(basicStroke2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f3) * d, ((Point2D)double_).getY() + (double)(f5 - f3) * d2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d, ((Point2D)double_).getY() + (double)f5 * d2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n3 = 0;
                n2 += 15;
            }
            if (n2 == 90) {
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f4) * d, ((Point2D)double_).getY() + (double)(f5 - f4) * d2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d, ((Point2D)double_).getY() + (double)f5 * d2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n2 = 0;
            }
            graphics2D.setFont(font);
            graphics2D.setColor(color);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f) * d, ((Point2D)double_).getY() + (double)(f5 - f) * d2);
            switch (n5) {
                case 360: {
                    graphics2D.setFont(font);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "S", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 45: {
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "SW", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 90: {
                    graphics2D.setFont(font);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "W", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 135: {
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "NW", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 180: {
                    graphics2D.setFont(font);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "N", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 225: {
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "NE", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 270: {
                    graphics2D.setFont(font);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "E", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                    break;
                }
                case 315: {
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "SE", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d3));
                }
            }
            graphics2D.setTransform(affineTransform);
            ++n4;
            ++n3;
            ++n5;
        }
        graphics2D.setTransform(affineTransform);
    }

    @Override
    protected BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4672897196261682, (double)n3 * 0.4532710280373832, (double)n2 * 0.4672897196261682, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.46261682242990654, (double)n2 * 0.4439252336448598, (double)n3 * 0.48130841121495327, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5, (double)n2 * 0.5560747663551402, (double)n3 * 0.5, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.46261682242990654, (double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168);
                generalPath2.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168, (double)n2 * 0.5, (double)n3 * 0.8504672897196262, (double)n2 * 0.5, (double)n3 * 0.8504672897196262);
                generalPath2.curveTo((double)n2 * 0.5, (double)n3 * 0.8504672897196262, (double)n2 * 0.5327102803738317, (double)n3 * 0.5467289719626168, (double)n2 * 0.5327102803738317, (double)n3 * 0.5467289719626168);
                generalPath2.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.5373831775700935, (double)n2 * 0.5560747663551402, (double)n3 * 0.5186915887850467, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.5, (double)n2 * 0.4439252336448598, (double)n3 * 0.5, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5186915887850467, (double)n2 * 0.4532710280373832, (double)n3 * 0.5373831775700935, (double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168);
                generalPath2.closePath();
                Point2D.Double double_3 = new Point2D.Double(generalPath2.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_4 = new Point2D.Double(generalPath2.getBounds2D().getMaxX(), 0.0);
                float[] fArray2 = new float[]{0.0f, 0.48f, 0.48009998f, 1.0f};
                Color[] colorArray2 = new Color[]{new Color(227, 229, 232, 255), new Color(227, 229, 232, 255), new Color(171, 177, 184, 255), new Color(171, 177, 184, 255)};
                LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(generalPath2);
                graphics2D.setColor(new Color(11252152));
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath2);
                break;
            }
            case TYPE3: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4439252336448598, (double)n3 * 0.49065420560747663, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5327102803738317, (double)n2 * 0.4672897196261682, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5560747663551402, (double)n2 * 0.5560747663551402, (double)n3 * 0.5327102803738317, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_5 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_5, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_6 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_6, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                GeneralPath generalPath3 = new GeneralPath();
                generalPath3.setWindingRule(0);
                generalPath3.moveTo((double)n2 * 0.5, (double)n3 * 0.5046728971962616);
                generalPath3.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5046728971962616);
                generalPath3.lineTo((double)n2 * 0.5, (double)n3 * 0.8504672897196262);
                generalPath3.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5046728971962616);
                generalPath3.lineTo((double)n2 * 0.5, (double)n3 * 0.5046728971962616);
                generalPath3.closePath();
                Point2D.Double double_7 = new Point2D.Double(generalPath3.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_8 = new Point2D.Double(generalPath3.getBounds2D().getMaxX(), 0.0);
                float[] fArray3 = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray3 = new Color[]{new Color(227, 229, 232, 255), new Color(227, 229, 232, 255), new Color(171, 177, 184, 255), new Color(171, 177, 184, 255)};
                LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_7, double_8, fArray3, colorArray3);
                graphics2D.setPaint(linearGradientPaint3);
                graphics2D.fill(generalPath3);
                Color color = new Color(11252152);
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath3);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        switch (this.getPointerType()) {
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4672897196261682, (double)n3 * 0.4532710280373832, (double)n2 * 0.4672897196261682, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.46261682242990654, (double)n2 * 0.4439252336448598, (double)n3 * 0.48130841121495327, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5, (double)n2 * 0.5560747663551402, (double)n3 * 0.5, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.46261682242990654, (double)n2 * 0.5327102803738317, (double)n3 * 0.4532710280373832);
                generalPath.closePath();
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168);
                generalPath2.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168, (double)n2 * 0.5, (double)n3 * 0.8504672897196262, (double)n2 * 0.5, (double)n3 * 0.8504672897196262);
                generalPath2.curveTo((double)n2 * 0.5, (double)n3 * 0.8504672897196262, (double)n2 * 0.5327102803738317, (double)n3 * 0.5467289719626168, (double)n2 * 0.5327102803738317, (double)n3 * 0.5467289719626168);
                generalPath2.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.5373831775700935, (double)n2 * 0.5560747663551402, (double)n3 * 0.5186915887850467, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.5, (double)n2 * 0.4439252336448598, (double)n3 * 0.5, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5186915887850467, (double)n2 * 0.4532710280373832, (double)n3 * 0.5373831775700935, (double)n2 * 0.4672897196261682, (double)n3 * 0.5467289719626168);
                generalPath2.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                graphics2D.fill(generalPath2);
                break;
            }
            case TYPE3: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4439252336448598, (double)n3 * 0.49065420560747663, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5327102803738317, (double)n2 * 0.4672897196261682, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5560747663551402, (double)n2 * 0.5560747663551402, (double)n3 * 0.5327102803738317, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                GeneralPath generalPath3 = new GeneralPath();
                generalPath3.setWindingRule(0);
                generalPath3.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                generalPath3.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5841121495327103, (double)n2 * 0.5093457943925234, (double)n3 * 0.602803738317757);
                generalPath3.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.616822429906542, (double)n2 * 0.5, (double)n3 * 0.8691588785046729, (double)n2 * 0.5, (double)n3 * 0.8691588785046729);
                generalPath3.curveTo((double)n2 * 0.5, (double)n3 * 0.8691588785046729, (double)n2 * 0.49065420560747663, (double)n3 * 0.616822429906542, (double)n2 * 0.49065420560747663, (double)n3 * 0.602803738317757);
                generalPath3.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5841121495327103, (double)n2 * 0.48598130841121495, (double)n3 * 0.5420560747663551, (double)n2 * 0.48130841121495327, (double)n3 * 0.5280373831775701);
                generalPath3.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5186915887850467, (double)n2 * 0.4672897196261682, (double)n3 * 0.5093457943925234, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath3.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.48130841121495327, (double)n2 * 0.48130841121495327, (double)n3 * 0.4672897196261682, (double)n2 * 0.5, (double)n3 * 0.4672897196261682);
                generalPath3.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4672897196261682, (double)n2 * 0.5327102803738317, (double)n3 * 0.48130841121495327, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath3.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5093457943925234, (double)n2 * 0.5280373831775701, (double)n3 * 0.5186915887850467, (double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                generalPath3.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                graphics2D.fill(generalPath3);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Compass";
    }
}

