/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.Timer;

public class TrafficLight
extends JComponent
implements ActionListener {
    public static final String RED_PROPERTY = "red";
    public static final String YELLOW_PROPERTY = "yellow";
    public static final String GREEN_PROPERTY = "green";
    private static final BufferedImage HATCH_TEXTURE = TrafficLight.createHatchTexture();
    private boolean blink;
    private boolean redOn;
    private boolean redBlinking;
    private boolean yellowOn;
    private boolean yellowBlinking;
    private boolean greenOn;
    private boolean greenBlinking;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 98, 278);
    private final Point2D CENTER;
    private BufferedImage housingImage;
    private BufferedImage greenImage;
    private BufferedImage greenOnImage;
    private BufferedImage greenOffImage;
    private BufferedImage yellowImage;
    private BufferedImage yellowOnImage;
    private BufferedImage yellowOffImage;
    private BufferedImage redImage;
    private BufferedImage redOnImage;
    private BufferedImage redOffImage;
    private boolean square;
    private final Timer TIMER;
    private int timerPeriod;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = TrafficLight.this.getWidth() <= TrafficLight.this.getHeight() ? TrafficLight.this.getWidth() : TrafficLight.this.getHeight();
            Container container = TrafficLight.this.getParent();
            if (container != null && container.getLayout() == null) {
                if (n < TrafficLight.this.getMinimumSize().width || n < TrafficLight.this.getMinimumSize().height) {
                    TrafficLight.this.setSize(TrafficLight.this.getMinimumSize());
                } else if (TrafficLight.this.square) {
                    TrafficLight.this.setSize(n, n);
                } else {
                    TrafficLight.this.setSize(TrafficLight.this.getWidth(), TrafficLight.this.getHeight());
                }
            } else if (n < TrafficLight.this.getMinimumSize().width || n < TrafficLight.this.getMinimumSize().height) {
                TrafficLight.this.setPreferredSize(TrafficLight.this.getMinimumSize());
            } else if (TrafficLight.this.square) {
                TrafficLight.this.setPreferredSize(new Dimension(n, n));
            } else {
                TrafficLight.this.setPreferredSize(new Dimension(TrafficLight.this.getWidth(), TrafficLight.this.getHeight()));
            }
            TrafficLight.this.calcInnerBounds();
            TrafficLight.this.init(((TrafficLight)TrafficLight.this).getInnerBounds().width, ((TrafficLight)TrafficLight.this).getInnerBounds().height);
        }
    };

    public TrafficLight() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.timerPeriod = 1000;
        this.TIMER = new Timer(this.timerPeriod, this);
        this.housingImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOnImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOffImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOnImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOffImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOnImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOffImage = Util.INSTANCE.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.blink = false;
        this.redOn = false;
        this.redBlinking = false;
        this.yellowOn = false;
        this.yellowBlinking = false;
        this.greenOn = false;
        this.greenBlinking = false;
        this.square = false;
    }

    public final void init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (this.housingImage != null) {
            this.housingImage.flush();
        }
        this.housingImage = this.createHousingImage(n, n2);
        if (this.greenImage != null) {
            this.greenImage.flush();
        }
        this.greenImage = this.createGreenLightImage(n, n2);
        if (this.greenOnImage != null) {
            this.greenOnImage.flush();
        }
        this.greenOnImage = this.createGreenOnImage(n, n2);
        if (this.greenOffImage != null) {
            this.greenOffImage.flush();
        }
        this.greenOffImage = this.createGreenOffImage(n, n2);
        if (this.yellowImage != null) {
            this.yellowImage.flush();
        }
        this.yellowImage = this.createYellowLightImage(n, n2);
        if (this.yellowOnImage != null) {
            this.yellowOnImage.flush();
        }
        this.yellowOnImage = this.createYellowOnImage(n, n2);
        if (this.yellowOffImage != null) {
            this.yellowOffImage.flush();
        }
        this.yellowOffImage = this.createYellowOffImage(n, n2);
        if (this.redImage != null) {
            this.redImage.flush();
        }
        this.redImage = this.createRedLightImage(n, n2);
        if (this.redOnImage != null) {
            this.redOnImage.flush();
        }
        this.redOnImage = this.createRedOnImage(n, n2);
        if (this.redOffImage != null) {
            this.redOffImage.flush();
        }
        this.redOffImage = this.createRedOffImage(n, n2);
        this.CENTER.setLocation((double)n / 2.0, (double)n2 / 2.0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        graphics2D.drawImage((Image)this.housingImage, 0, 0, null);
        graphics2D.drawImage((Image)this.greenImage, 0, 0, null);
        if (this.greenOn) {
            graphics2D.drawImage((Image)this.greenOnImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.greenOffImage, 0, 0, null);
        graphics2D.drawImage((Image)this.yellowImage, 0, 0, null);
        if (this.yellowOn) {
            graphics2D.drawImage((Image)this.yellowOnImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.yellowOffImage, 0, 0, null);
        graphics2D.drawImage((Image)this.redImage, 0, 0, null);
        if (this.redOn) {
            graphics2D.drawImage((Image)this.redOnImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.redOffImage, 0, 0, null);
        graphics2D.dispose();
    }

    public boolean isRedOn() {
        return this.redOn;
    }

    public void setRedOn(boolean bl) {
        boolean bl2 = this.redOn;
        this.redOn = bl;
        this.propertySupport.firePropertyChange(RED_PROPERTY, bl2, this.redOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowOn() {
        return this.yellowOn;
    }

    public void setYellowOn(boolean bl) {
        boolean bl2 = this.yellowOn;
        this.yellowOn = bl;
        this.propertySupport.firePropertyChange(YELLOW_PROPERTY, bl2, this.yellowOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGreenOn() {
        return this.greenOn;
    }

    public void setGreenOn(boolean bl) {
        boolean bl2 = this.greenOn;
        this.greenOn = bl;
        this.propertySupport.firePropertyChange(GREEN_PROPERTY, bl2, this.greenOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isRedBlinking() {
        return this.redBlinking;
    }

    public void setRedBlinking(boolean bl) {
        this.redBlinking = bl;
        if (!bl) {
            this.redOn = false;
            this.TIMER.stop();
        } else {
            this.TIMER.start();
        }
    }

    public boolean isYellowBlinking() {
        return this.yellowBlinking;
    }

    public void setYellowBlinking(boolean bl) {
        this.yellowBlinking = bl;
        if (!bl) {
            this.yellowOn = false;
            this.TIMER.stop();
        } else {
            this.TIMER.start();
        }
    }

    public boolean isGreenBlinking() {
        return this.greenBlinking;
    }

    public void setGreenBlinking(boolean bl) {
        this.greenBlinking = bl;
        if (!bl) {
            this.greenOn = false;
            this.TIMER.stop();
        } else {
            this.TIMER.start();
        }
    }

    public int getTimerPeriod() {
        return this.timerPeriod;
    }

    public void setTimerPeriod(int n) {
        this.timerPeriod = n < 100 ? 100 : (n > 10000 ? 10000 : n);
        this.TIMER.setDelay(this.timerPeriod);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        int n = this.getWidth() < (int)((double)this.getHeight() * 0.3525179856) ? (int)((double)this.getWidth() * 2.8367346939) : this.getHeight();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 0.3525179856) - insets.left - insets.right, n - insets.top - insets.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n;
        int n2 = n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(n, n));
        } else {
            super.setPreferredSize(dimension);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int n, int n2) {
        int n3;
        int n4 = n3 = n <= n2 ? n : n2;
        if (this.square) {
            super.setSize(n3, n3);
        } else {
            super.setSize(n, n2);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n;
        int n2 = n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        if (this.square) {
            super.setSize(new Dimension(n, n));
        } else {
            super.setSize(dimension);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        int n;
        int n2 = n = rectangle.width <= rectangle.height ? rectangle.width : rectangle.height;
        if (this.square) {
            super.setBounds(rectangle.x, rectangle.y, n, n);
        } else {
            super.setBounds(rectangle);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n3 <= n4 ? n3 : n4;
        if (this.square) {
            super.setBounds(n, n2, n5, n5);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public BufferedImage createHousingImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0 * (double)n3, 0.0 * (double)n4, 1.0 * (double)n3, 1.0 * (double)n4, 0.21428571428571427 * (double)n3, 0.07553956834532374 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.04081632653061224 * (double)n3, 0.007194244604316547 * (double)n4), new Point2D.Double(0.9521011364730593 * (double)n3, 0.9958824935586308 * (double)n4), new float[]{0.0f, 0.01f, 0.09f, 0.24f, 0.55f, 0.78f, 0.98f, 1.0f}, new Color[]{new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.12156863f, 0.12156863f, 0.12156863f, 1.0f), new Color(0.21176471f, 0.21176471f, 0.21176471f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        graphics2D.fill(double_);
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(0.030612244897959183 * (double)n3, 0.01079136690647482 * (double)n4, 0.9387755102040817 * (double)n3, 0.9784172661870504 * (double)n4, 0.1683673469387755 * (double)n3, 0.05935251798561151 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(-0.1326530612244898 * (double)n3, -0.0539568345323741 * (double)n4), new Point2D.Double(2.0614080436330213 * (double)n3, 0.6672932297063833 * (double)n4), new float[]{0.0f, 0.01f, 0.16f, 0.31f, 0.44f, 0.65f, 0.87f, 0.98f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.21568628f, 0.21568628f, 0.20784314f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.1882353f, 0.1882353f, 0.1882353f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.21176471f, 0.21176471f, 0.21176471f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        graphics2D.fill(double_2);
        Random random = new Random();
        Random random2 = new Random();
        graphics2D.setClip(double_2);
        Color color = new Color(0.2f, 0.2f, 0.2f);
        Color color2 = new Color(0.8f, 0.8f, 0.8f);
        int n5 = 0;
        while ((double)n5 < ((RectangularShape)double_2).getHeight()) {
            int n6 = 0;
            while ((double)n6 < ((RectangularShape)double_2).getWidth()) {
                Color color3 = random.nextBoolean() ? color2 : color;
                int n7 = 10 + random2.nextInt(10) - 5;
                graphics2D.setColor(new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), n7));
                graphics2D.drawLine((int)((double)n6 + double_2.getMinX()), (int)((double)n5 + double_2.getMinY()), (int)((double)n6 + double_2.getMinX()), (int)((double)n5 + double_2.getMinY()));
                ++n6;
            }
            ++n5;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createGreenLightImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.6654676258992805 * (double)n4, 0.7959183673469388 * (double)n3, 0.2805755395683453 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.6654676258992805 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.9460431654676259 * (double)n4), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.6870503597122302 * (double)n4, 0.7959183673469388 * (double)n3, 0.2589928057553957 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.6870503597122302 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.9460431654676259 * (double)n4), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.6834532374100719 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8093525179856115 * (double)n4), 0.3622449f * (float)n3, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_3);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.6834532374100719 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.6870503597122302 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.9172661870503597 * (double)n4), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        graphics2D.fill(double_4);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createGreenOnImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.6942446043165468 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8093525179856115 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.33333334f, 0.7254902f, 0.48235294f, 1.0f), new Color(0.0f, 0.12156863f, 0.0f, 1.0f)}));
        graphics2D.fill(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.0 * (double)n3, 0.8129496402877698 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.9100719424460432 * (double)n4, 0.22448979591836735 * (double)n3, 0.9892086330935251 * (double)n4, 0.5 * (double)n3, 0.9892086330935251 * (double)n4);
        generalPath.curveTo(0.7755102040816326 * (double)n3, 0.9892086330935251 * (double)n4, 1.0 * (double)n3, 0.9100719424460432 * (double)n4, 1.0 * (double)n3, 0.8093525179856115 * (double)n4);
        generalPath.curveTo(0.9081632653061225 * (double)n3, 0.7517985611510791 * (double)n4, 0.7040816326530612 * (double)n3, 0.6870503597122302 * (double)n4, 0.5 * (double)n3, 0.6870503597122302 * (double)n4);
        generalPath.curveTo(0.2857142857142857 * (double)n3, 0.6870503597122302 * (double)n4, 0.08163265306122448 * (double)n3, 0.7517985611510791 * (double)n4, 0.0 * (double)n3, 0.8129496402877698 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8093525179856115 * (double)n4), 0.5153061f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.25490198f, 0.73333335f, 0.49411765f, 1.0f), new Color(0.015686274f, 0.14509805f, 0.031372547f, 0.0f)}));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createGreenOffImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.6942446043165468 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8093525179856115 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 0.24705882f), new Color(0.0f, 1.0f, 0.0f, 0.047058824f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.6942446043165468 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8093525179856115 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_2);
        TexturePaint texturePaint = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        graphics2D.setPaint(texturePaint);
        graphics2D.fill(double_2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createYellowLightImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.35611510791366907 * (double)n4, 0.7959183673469388 * (double)n3, 0.2805755395683453 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.35611510791366907 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.6366906474820144 * (double)n4), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.3776978417266187 * (double)n4, 0.7959183673469388 * (double)n3, 0.2589928057553957 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.3776978417266187 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.6366906474820144 * (double)n4), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.37410071942446044 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.3622449f * (float)n3, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_3);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.37410071942446044 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.3776978417266187 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.6079136690647482 * (double)n4), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        graphics2D.fill(double_4);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createYellowOnImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.38489208633093525 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.99607843f, 0.83137256f, 0.20392157f, 1.0f), new Color(0.50980395f, 0.2f, 0.047058824f, 1.0f)}));
        graphics2D.fill(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.0 * (double)n3, 0.5035971223021583 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.6007194244604317 * (double)n4, 0.22448979591836735 * (double)n3, 0.6798561151079137 * (double)n4, 0.5 * (double)n3, 0.6798561151079137 * (double)n4);
        generalPath.curveTo(0.7755102040816326 * (double)n3, 0.6798561151079137 * (double)n4, 1.0 * (double)n3, 0.6007194244604317 * (double)n4, 1.0 * (double)n3, 0.5 * (double)n4);
        generalPath.curveTo(0.9081632653061225 * (double)n3, 0.44244604316546765 * (double)n4, 0.7040816326530612 * (double)n3, 0.3776978417266187 * (double)n4, 0.5 * (double)n3, 0.3776978417266187 * (double)n4);
        generalPath.curveTo(0.2857142857142857 * (double)n3, 0.3776978417266187 * (double)n4, 0.08163265306122448 * (double)n3, 0.44244604316546765 * (double)n4, 0.0 * (double)n3, 0.5035971223021583 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.5153061f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.99607843f, 0.83137256f, 0.20392157f, 1.0f), new Color(0.50980395f, 0.2f, 0.047058824f, 0.0f)}));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createYellowOffImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.38489208633093525 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 0.24705882f), new Color(1.0f, 1.0f, 0.0f, 0.047058824f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.38489208633093525 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_2);
        TexturePaint texturePaint = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        graphics2D.setPaint(texturePaint);
        graphics2D.fill(double_2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createRedLightImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.046762589928057555 * (double)n4, 0.7959183673469388 * (double)n3, 0.2805755395683453 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.046762589928057555 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.3273381294964029 * (double)n4), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.10204081632653061 * (double)n3, 0.0683453237410072 * (double)n4, 0.7959183673469388 * (double)n3, 0.2589928057553957 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.0683453237410072 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.3273381294964029 * (double)n4), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.06474820143884892 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.1906474820143885 * (double)n4), 0.3622449f * (float)n3, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        graphics2D.fill(double_3);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.14285714285714285 * (double)n3, 0.06474820143884892 * (double)n4, 0.7142857142857143 * (double)n3, 0.2517985611510791 * (double)n4);
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.0683453237410072 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.29856115107913667 * (double)n4), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        graphics2D.fill(double_4);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createRedOnImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.07553956834532374 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.1906474820143885 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.015686274f, 1.0f)}));
        graphics2D.fill(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.0 * (double)n3, 0.19424460431654678 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.29136690647482016 * (double)n4, 0.22448979591836735 * (double)n3, 0.37050359712230213 * (double)n4, 0.5 * (double)n3, 0.37050359712230213 * (double)n4);
        generalPath.curveTo(0.7755102040816326 * (double)n3, 0.37050359712230213 * (double)n4, 1.0 * (double)n3, 0.29136690647482016 * (double)n4, 1.0 * (double)n3, 0.1906474820143885 * (double)n4);
        generalPath.curveTo(0.9081632653061225 * (double)n3, 0.13309352517985612 * (double)n4, 0.7040816326530612 * (double)n3, 0.0683453237410072 * (double)n4, 0.5 * (double)n3, 0.0683453237410072 * (double)n4);
        generalPath.curveTo(0.2857142857142857 * (double)n3, 0.0683453237410072 * (double)n4, 0.08163265306122448 * (double)n3, 0.13309352517985612 * (double)n4, 0.0 * (double)n3, 0.19424460431654678 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.1906474820143885 * (double)n4), 0.5153061f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.4627451f, 0.019607844f, 0.0039215684f, 0.0f)}));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createRedOffImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.07553956834532374 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.1906474820143885 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 0.24705882f), new Color(1.0f, 0.0f, 0.0f, 0.047058824f)}));
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.17346938775510204 * (double)n3, 0.07553956834532374 * (double)n4, 0.6530612244897959 * (double)n3, 0.2302158273381295 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.1906474820143885 * (double)n4), 0.3265306f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_2);
        TexturePaint texturePaint = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        graphics2D.setPaint(texturePaint);
        graphics2D.fill(double_2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage createHatchTexture() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(2, 2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        graphics2D.drawLine(0, 0, 1, 0);
        graphics2D.drawLine(0, 1, 0, 1);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.blink ^= true;
        this.redOn = this.redBlinking ? this.blink : false;
        this.yellowOn = this.yellowBlinking ? this.blink : false;
        boolean bl = this.greenOn = this.greenBlinking ? this.blink : false;
        if (this.redOn) {
            this.propertySupport.firePropertyChange(RED_PROPERTY, !this.redOn, this.redOn);
        }
        if (this.yellowOn) {
            this.propertySupport.firePropertyChange(RED_PROPERTY, !this.yellowOn, this.yellowOn);
        }
        if (this.greenOn) {
            this.propertySupport.firePropertyChange(RED_PROPERTY, !this.greenOn, this.greenOn);
        }
        this.repaint(this.INNER_BOUNDS);
    }

    @Override
    public String toString() {
        return "Trafficlight";
    }
}

