/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.Direction;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Scaler;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Random;

public final class Radial1Square
extends AbstractRadial {
    private static final int BASE = 10;
    private static final double TICKMARK_ROTATION_OFFSET = 1.5707963267948966;
    private final double ROTATION_OFFSET;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private final Point2D ROTATION_CENTER;
    private final Point2D TRACK_OFFSET;
    private final Point2D TICKMARKS_OFFSET;
    private final Point2D THRESHOLD_OFFSET;
    private final Point2D MEASURED_OFFSET;
    private double thresholdRotationOffset;
    private double measuredRotationOffset;
    private float titleOffsetYFactor;
    private float unitOffsetYFactor;
    private double angle;
    private final Color DARK_NOISE;
    private final Color BRIGHT_NOISE;

    public Radial1Square() {
        this.getModel().setGaugeType(GaugeType.TYPE1);
        this.ROTATION_OFFSET = 4.71238898038469 + this.getModel().getFreeAreaAngle() / 2.0;
        this.ROTATION_CENTER = new Point2D.Double(0.0, 0.0);
        this.TRACK_OFFSET = new Point2D.Double(0.0, 0.0);
        this.TICKMARKS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.THRESHOLD_OFFSET = new Point2D.Double(0.0, 0.0);
        this.MEASURED_OFFSET = new Point2D.Double(0.0, 0.0);
        this.measuredRotationOffset = 0.0;
        this.thresholdRotationOffset = 0.0;
        this.titleOffsetYFactor = 0.6f;
        this.unitOffsetYFactor = 0.67f;
        this.angle = 0.0;
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.setLedPosition(0.45, 0.45);
        this.setUserLedPosition(0.6, 0.45);
        this.setOrientation(Orientation.NORTH_WEST);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial1Square(Model model) {
        this.setModel(model);
        this.ROTATION_OFFSET = 4.71238898038469 + this.getModel().getFreeAreaAngle() / 2.0;
        this.ROTATION_CENTER = new Point2D.Double(0.0, 0.0);
        this.TRACK_OFFSET = new Point2D.Double(0.0, 0.0);
        this.TICKMARKS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.THRESHOLD_OFFSET = new Point2D.Double(0.0, 0.0);
        this.MEASURED_OFFSET = new Point2D.Double(0.0, 0.0);
        this.measuredRotationOffset = 0.0;
        this.thresholdRotationOffset = 0.0;
        this.titleOffsetYFactor = 0.6f;
        this.unitOffsetYFactor = 0.67f;
        this.angle = 0.0;
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(n4, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n4, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n4, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                d4 = 1.5707963267948966;
                this.TRACK_OFFSET.setLocation(-((double)n4 / 1.55), 0.0);
                break;
            }
            case SOUTH_EAST: {
                d4 = Math.PI;
                this.TRACK_OFFSET.setLocation(-((double)n4 / 1.55), -((double)n4 / 1.55));
                break;
            }
            case SOUTH_WEST: {
                d4 = 4.71238898038469;
                this.TRACK_OFFSET.setLocation(0.0, -((double)n4 / 1.55));
                break;
            }
            default: {
                d4 = 0.0;
                this.TRACK_OFFSET.setLocation(0.0, 0.0);
            }
        }
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(n4, this.getModel().getFreeAreaAngle(), 1.5707963267948966 + d4, this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.68f, new Point2D.Double((double)n4 * 0.8271028037, (double)n4 * 0.8271028037), this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                this.TICKMARKS_OFFSET.setLocation(-((double)n4 / 1.55), 0.0);
                break;
            }
            case SOUTH_EAST: {
                this.TICKMARKS_OFFSET.setLocation(-((double)n4 / 1.55), -((double)n4 / 1.55));
                break;
            }
            case SOUTH_WEST: {
                this.TICKMARKS_OFFSET.setLocation(0.0, -((double)n4 / 1.55));
                break;
            }
            default: {
                this.TICKMARKS_OFFSET.setLocation(0.0, 0.0);
            }
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(n4, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), this.isSectionTickmarksOnly(), this.getSections(), 0.68f, 0.09f, new Point2D.Double((double)n4 * 0.8271028037, (double)n4 * 0.8271028037), new Point2D.Double(0.0, 0.0), Orientation.NORTH_WEST, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(n4, this.getPointerType()) : null;
        this.create_POSTS_Image(n4, this.fImage);
        if (this.isForegroundVisible()) {
            this.create_FOREGROUND_Image(n4, this.fImage);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                d3 = 1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.775, (double)this.bImage.getHeight() * 0.81);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = this.ROTATION_OFFSET + (this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            case SOUTH_EAST: {
                d3 = 1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.79, (double)this.bImage.getHeight() * 0.16);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET + (this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            case SOUTH_WEST: {
                d3 = -1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.19, (double)this.bImage.getHeight() * 0.16);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            default: {
                d3 = 0.0;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.805, (double)this.bImage.getHeight() * 0.19);
                this.thresholdRotationOffset = !this.isLogScale() ? this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep() : this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
            }
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(n4, d3);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                d2 = 1.5707963267948966;
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.815);
                break;
            }
            case SOUTH_EAST: {
                d2 = 1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.15);
                this.measuredRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET;
                break;
            }
            case SOUTH_WEST: {
                d2 = -1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.1, (double)this.bImage.getHeight() * 0.16);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                break;
            }
            default: {
                d2 = 0.0;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.811, (double)this.bImage.getHeight() * 0.11);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
            }
        }
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(0, 23, 252, 255), d2);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                d = 1.5707963267948966;
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.815);
                break;
            }
            case SOUTH_EAST: {
                d = 1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.15);
                this.measuredRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET;
                break;
            }
            case SOUTH_WEST: {
                d = -1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.1, (double)this.bImage.getHeight() * 0.16);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                break;
            }
            default: {
                d = 0.0;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.811, (double)this.bImage.getHeight() * 0.11);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
            }
        }
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(252, 29, 0, 255), d);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                this.ROTATION_CENTER.setLocation((double)n4 - (double)n4 * 0.8271028037, (double)n4 * 0.8271028037);
                this.titleOffsetYFactor = 0.6f;
                this.unitOffsetYFactor = 0.67f;
                break;
            }
            case SOUTH_EAST: {
                this.ROTATION_CENTER.setLocation((double)n4 - (double)n4 * 0.8271028037, (double)n4 - (double)n4 * 0.8271028037);
                this.titleOffsetYFactor = 0.3f;
                this.unitOffsetYFactor = 0.37f;
                break;
            }
            case SOUTH_WEST: {
                this.ROTATION_CENTER.setLocation((double)n4 * 0.8271028037, (double)n4 - (double)n4 * 0.8271028037);
                this.titleOffsetYFactor = 0.3f;
                this.unitOffsetYFactor = 0.37f;
                break;
            }
            default: {
                this.ROTATION_CENTER.setLocation((double)n4 * 0.8271028037, (double)n4 * 0.8271028037);
                this.titleOffsetYFactor = 0.6f;
                this.unitOffsetYFactor = 0.67f;
            }
        }
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle2D rectangle2D;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            for (Section object2 : this.getAreas()) {
                if (!object2.contains(this.getValue())) continue;
                graphics2D.setColor(object2.getHighlightColor());
                graphics2D.fill(object2.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                graphics2D.fill(section.getSectionArea());
                break;
            }
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            }
            TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getTitle(), (float)(((double)this.getGaugeBounds().width - rectangle2D.getWidth()) / 2.0), this.titleOffsetYFactor * (float)this.getGaugeBounds().height + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.bImage.getWidth())));
            }
            TextLayout textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getUnitString(), (float)(((double)this.getGaugeBounds().width - rectangle2D.getWidth()) / 2.0), this.unitOffsetYFactor * (float)this.getGaugeBounds().width + textLayout.getAscent() - textLayout.getDescent());
        }
        if (this.isThresholdVisible()) {
            graphics2D.rotate(this.thresholdRotationOffset, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
            graphics2D.drawImage((Image)this.thresholdImage, (int)this.THRESHOLD_OFFSET.getX(), (int)this.THRESHOLD_OFFSET.getY(), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_EAST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_WEST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case NORTH_WEST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                }
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)this.MEASURED_OFFSET.getX(), (int)this.MEASURED_OFFSET.getY(), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_EAST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_WEST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case NORTH_WEST: {
                    if (!this.isLogScale()) {
                        graphics2D.rotate(this.measuredRotationOffset + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    graphics2D.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                }
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)this.MEASURED_OFFSET.getX(), (int)this.MEASURED_OFFSET.getY(), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getY()), null);
        }
        switch (this.getOrientation()) {
            case SOUTH_EAST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue() - this.getMaxValue()) * -this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue() - this.getMaxValue()) * -this.getLogAngleStep();
                break;
            }
            case SOUTH_WEST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue() - this.getMaxValue()) * this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue() - this.getMaxValue()) * this.getLogAngleStep();
                break;
            }
            case NORTH_EAST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue()) * -this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * -this.getLogAngleStep();
                break;
            }
            default: {
                this.angle = !this.isLogScale() ? (this.getValue() - this.getMinValue()) * this.getAngleStep() : UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
            }
        }
        graphics2D.rotate(this.angle, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY() + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(this.angle, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public GaugeType getGaugeType() {
        return GaugeType.TYPE1;
    }

    @Override
    public Orientation getOrientation() {
        return Orientation.NORTH_WEST;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                this.setTickmarkDirection(Direction.CLOCKWISE);
                break;
            }
            case NORTH_EAST: {
                this.setTickmarkDirection(Direction.COUNTER_CLOCKWISE);
                break;
            }
            case SOUTH_EAST: {
                this.setTickmarkDirection(Direction.COUNTER_CLOCKWISE);
                break;
            }
            case SOUTH_WEST: {
                this.setTickmarkDirection(Direction.CLOCKWISE);
            }
        }
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0, (double)this.bImage.getHeight() / 2.0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private void createAreas(BufferedImage bufferedImage) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (this.bImage != null && !this.getAreas().isEmpty()) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (float)this.bImage.getWidth() * 0.3411215f;
            double d4 = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? d3 - (double)((float)this.bImage.getWidth() * 0.12f) : d3 - (double)((float)this.bImage.getWidth() * 0.023364486f)) : d3;
            double d5 = (double)this.bImage.getWidth() / 2.0 - d4;
            Rectangle2D.Double double_2 = new Rectangle2D.Double((double)this.bImage.getMinX() + d5 * 0.9 + ((Point2D)double_).getX(), (double)this.bImage.getMinY() + d5 * 0.9 + ((Point2D)double_).getY(), 4.0 * d4, 4.0 * d4);
            for (Section section : this.getAreas()) {
                switch (this.getOrientation()) {
                    case NORTH_EAST: {
                        if (!this.isLogScale()) {
                            d = 90.0 - Math.toDegrees((this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getAngleStep());
                            d2 = 90.0 - Math.toDegrees((this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d2 = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_).setLocation((double)(-this.bImage.getWidth()) * 0.45, (double)this.bImage.getWidth() * 0.195);
                        break;
                    }
                    case SOUTH_EAST: {
                        if (!this.isLogScale()) {
                            d = 0.0 - Math.toDegrees((this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getAngleStep());
                            d2 = 0.0 - Math.toDegrees((this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d2 = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_).setLocation((double)(-this.bImage.getWidth()) * 0.45, (double)(-this.bImage.getWidth()) * 0.45);
                        break;
                    }
                    case SOUTH_WEST: {
                        if (!this.isLogScale()) {
                            d = 270.0 - Math.toDegrees((section.getStop() - this.getMinValue()) * this.getAngleStep());
                            d2 = 270.0 - Math.toDegrees((section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d2 = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_).setLocation((double)this.bImage.getWidth() * 0.195, (double)(-this.bImage.getWidth()) * 0.45);
                        break;
                    }
                    default: {
                        if (!this.isLogScale()) {
                            d = 180.0 - Math.toDegrees((section.getStop() - this.getMinValue()) * this.getAngleStep());
                            d2 = 180.0 - Math.toDegrees((section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else if (!this.isLogScale()) {
                            d = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d2 = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        if (this.isSectionsVisible()) {
                            ((Point2D)double_).setLocation((double)this.bImage.getWidth() * 0.195, (double)this.bImage.getWidth() * 0.195);
                            break;
                        }
                        ((Point2D)double_).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)this.bImage.getWidth() * 0.148271028);
                    }
                }
                Arc2D.Double object2 = new Arc2D.Double(double_2, 0.0 - section.getStart() * this.getAngleStep(), -(section.getStop() - section.getStart()) * this.getAngleStep(), 2);
                object2.setFrame(((Point2D)double_).getX(), ((Point2D)double_).getY(), 4.0 * d4, 4.0 * d4);
                ((Arc2D)object2).setAngleStart(d2);
                ((Arc2D)object2).setAngleExtent(d - d2);
                section.setFilledArea(object2);
            }
            if (this.isAreasVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getAreas()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getFilledArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private void createSections(BufferedImage bufferedImage) {
        if (!this.getSections().isEmpty() && this.bImage != null) {
            double d;
            double d2 = (float)this.bImage.getWidth() * 0.3411215f;
            double d3 = this.isExpandedSectionsEnabled() ? d2 - (double)((float)this.bImage.getWidth() * 0.12f) : d2 - (double)((float)this.bImage.getWidth() * 0.023364486f);
            Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    ((RectangularShape)double_).setFrame((double)(-this.bImage.getWidth()) * 0.45, (double)this.bImage.getWidth() * 0.195, 4.0 * d3, 4.0 * d3);
                    break;
                }
                case SOUTH_EAST: {
                    ((RectangularShape)double_).setFrame((double)(-this.bImage.getWidth()) * 0.45, (double)(-this.bImage.getWidth()) * 0.45, 4.0 * d3, 4.0 * d3);
                    break;
                }
                case SOUTH_WEST: {
                    ((RectangularShape)double_).setFrame((double)this.bImage.getWidth() * 0.195, (double)(-this.bImage.getWidth()) * 0.45, 4.0 * d3, 4.0 * d3);
                    break;
                }
                default: {
                    d = this.isExpandedSectionsEnabled() ? (double)this.bImage.getWidth() * 0.38 : (double)this.bImage.getWidth() * 0.195;
                    ((RectangularShape)double_).setFrame(d, d, 4.0 * d3, 4.0 * d3);
                }
            }
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            for (Section object : this.getSections()) {
                double d4;
                switch (this.getOrientation()) {
                    case NORTH_EAST: {
                        if (!this.isLogScale()) {
                            d = 90.0 - Math.toDegrees((this.getMaxValue() - object.getStop() - this.getMinValue()) * this.getAngleStep());
                            d4 = 90.0 - Math.toDegrees((this.getMaxValue() - object.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - object.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d4 = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - object.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_2).setLocation((double)(-this.bImage.getWidth()) * 0.403271028, (double)this.bImage.getWidth() * 0.148271028);
                        break;
                    }
                    case SOUTH_EAST: {
                        if (!this.isLogScale()) {
                            d = 0.0 - Math.toDegrees((this.getMaxValue() - object.getStop() - this.getMinValue()) * this.getAngleStep());
                            d4 = 0.0 - Math.toDegrees((this.getMaxValue() - object.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - object.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d4 = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - object.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_2).setLocation((double)(-this.bImage.getWidth()) * 0.403271028, (double)(-this.bImage.getWidth()) * 0.403271028);
                        break;
                    }
                    case SOUTH_WEST: {
                        if (!this.isLogScale()) {
                            d = 270.0 - Math.toDegrees((object.getStop() - this.getMinValue()) * this.getAngleStep());
                            d4 = 270.0 - Math.toDegrees((object.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, object.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d4 = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, object.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_2).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)(-this.bImage.getWidth()) * 0.403271028);
                        break;
                    }
                    default: {
                        if (!this.isLogScale()) {
                            d = 180.0 - Math.toDegrees((object.getStop() - this.getMinValue()) * this.getAngleStep());
                            d4 = 180.0 - Math.toDegrees((object.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            d = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, object.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            d4 = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, object.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)double_2).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)this.bImage.getWidth() * 0.148271028);
                    }
                }
                Arc2D.Double double_3 = new Arc2D.Double(2);
                double_3.setFrame(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), 4.0 * d2, 4.0 * d2);
                ((Arc2D)double_3).setAngleStart(d4);
                ((Arc2D)double_3).setAngleExtent(d - d4);
                Area area = new Area(double_3);
                area.subtract(new Area(double_));
                object.setSectionArea(area);
            }
            if (this.isSectionsVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getSectionArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private void transformGraphics(int n, int n2, Graphics2D graphics2D) {
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                graphics2D.scale(-1.0, 1.0);
                graphics2D.translate(-n, 0);
                break;
            }
            case SOUTH_EAST: {
                graphics2D.scale(-1.0, -1.0);
                graphics2D.translate(-n, -n2);
                break;
            }
            case SOUTH_WEST: {
                graphics2D.scale(1.0, -1.0);
                graphics2D.translate(0, -n2);
                break;
            }
            default: {
                graphics2D.scale(1.0, 1.0);
            }
        }
    }

    private BufferedImage create_FRAME_Image(int n, BufferedImage bufferedImage) {
        Paint paint;
        Color[] colorArray;
        Object object;
        Object object2;
        Object[] objectArray;
        Paint paint2;
        Color[] colorArray2;
        float[] fArray;
        Point2D.Double double_;
        Point2D.Double double_2;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028);
        generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.08411214953271028, (double)n2 * 0.46261682242990654, (double)n3 * 0.1588785046728972, (double)n2 * 0.29439252336448596, (double)n3 * 0.32242990654205606);
        generalPath.curveTo((double)n2 * 0.17289719626168223, (double)n3 * 0.4439252336448598, (double)n2 * 0.08411214953271028, (double)n3 * 0.6635514018691588, (double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.closePath();
        Area area = new Area(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 1.0, (double)n3 * 1.0);
        generalPath2.curveTo((double)n2 * 1.0, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 0.0);
        generalPath2.curveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.0, (double)n2 * 0.0, (double)n3 * 0.308411214953271, (double)n2 * 0.0, (double)n3 * 1.0);
        generalPath2.curveTo((double)n2 * 0.0, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 1.0);
        generalPath2.closePath();
        graphics2D.setPaint(this.getOuterFrameColor());
        Area area2 = new Area(generalPath2);
        area2.subtract(area);
        graphics2D.fill(area2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384);
        generalPath3.curveTo((double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.004672897196261682, (double)n2 * 0.9953271028037384, (double)n3 * 0.004672897196261682);
        generalPath3.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.004672897196261682, (double)n2 * 0.004672897196261682, (double)n3 * 0.35514018691588783, (double)n2 * 0.004672897196261682, (double)n3 * 0.9953271028037384);
        generalPath3.curveTo((double)n2 * 0.004672897196261682, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384);
        generalPath3.closePath();
        Point2D.Double double_3 = new Point2D.Double(generalPath3.getBounds2D().getCenterX(), generalPath3.getBounds2D().getCenterY());
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
                break;
            }
            case NORTH_EAST: {
                double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
                break;
            }
            case SOUTH_EAST: {
                double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
                double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
                double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
                break;
            }
            default: {
                double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
            }
        }
        float f = (float)Math.toDegrees(Math.atan((float)n3 / 8.0f / ((float)n2 / 2.0f)));
        Area area3 = new Area(generalPath3);
        if (this.getFrameDesign() == FrameDesign.CUSTOM) {
            graphics2D.setPaint(this.getCustomFrameDesign());
            area3.subtract(area);
            graphics2D.fill(area3);
        } else {
            switch (this.getFrameDesign()) {
                case BLACK_METAL: {
                    fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                    colorArray2 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    paint2 = new ConicalGradientPaint(true, double_3, 0.0f, fArray, colorArray2);
                    graphics2D.setPaint(paint2);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case METAL: {
                    float[] fArray2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    objectArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    object2 = new LinearGradientPaint(double_2, double_, fArray2, (Color[])objectArray);
                    graphics2D.setPaint((Paint)object2);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case SHINY_METAL: {
                    object = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 4.0f * f, 180.0f, 270.0f - 4.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                    colorArray = this.isFrameBaseColorEnabled() ? new Color[]{new Color(254, 254, 254, 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(254, 254, 254, 255)} : new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                    paint = new ConicalGradientPaint(true, double_3, 0.0f, (float[])object, colorArray);
                    graphics2D.setPaint(paint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case GLOSSY_METAL: {
                    GeneralPath generalPath4 = new GeneralPath();
                    generalPath4.setWindingRule(0);
                    generalPath4.moveTo(0.9953271028037384 * (double)n2, 0.9953271028037384 * (double)n3);
                    generalPath4.curveTo(0.9953271028037384 * (double)n2, 0.9953271028037384 * (double)n3, 0.9953271028037384 * (double)n2, 0.004672897196261682 * (double)n3, 0.9953271028037384 * (double)n2, 0.004672897196261682 * (double)n3);
                    generalPath4.curveTo(0.3364485981308411 * (double)n2, 0.004672897196261682 * (double)n3, 0.004672897196261682 * (double)n2, 0.35514018691588783 * (double)n3, 0.004672897196261682 * (double)n2, 0.9953271028037384 * (double)n3);
                    generalPath4.curveTo(0.004672897196261682 * (double)n2, 0.9953271028037384 * (double)n3, 0.9953271028037384 * (double)n2, 0.9953271028037384 * (double)n3, 0.9953271028037384 * (double)n2, 0.9953271028037384 * (double)n3);
                    generalPath4.closePath();
                    Area area4 = new Area(generalPath4);
                    area4.subtract(area);
                    graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.9906542056074766 * (double)n2, 0.9813084112149533 * (double)n3), (float)(0.9789719626168224 * (double)n2), new float[]{0.0f, 0.94f, 1.0f}, new Color[]{new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f)}));
                    graphics2D.fill(area4);
                    GeneralPath generalPath5 = new GeneralPath();
                    generalPath5.setWindingRule(0);
                    generalPath5.moveTo(0.9906542056074766 * (double)n2, 0.9906542056074766 * (double)n3);
                    generalPath5.curveTo(0.9906542056074766 * (double)n2, 0.9906542056074766 * (double)n3, 0.9906542056074766 * (double)n2, 0.009345794392523364 * (double)n3, 0.9906542056074766 * (double)n2, 0.009345794392523364 * (double)n3);
                    generalPath5.curveTo(0.3364485981308411 * (double)n2, 0.009345794392523364 * (double)n3, 0.009345794392523364 * (double)n2, 0.3598130841121495 * (double)n3, 0.009345794392523364 * (double)n2, 0.9906542056074766 * (double)n3);
                    generalPath5.curveTo(0.009345794392523364 * (double)n2, 0.9906542056074766 * (double)n3, 0.9906542056074766 * (double)n2, 0.9906542056074766 * (double)n3, 0.9906542056074766 * (double)n2, 0.9906542056074766 * (double)n3);
                    generalPath5.closePath();
                    Area area5 = new Area(generalPath5);
                    area4.subtract(area);
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.9953271028037384 * (double)n2, 0.004672897196261682 * (double)n3), new Point2D.Double(0.9953271028037384 * (double)n2, 0.9906542056074766 * (double)n3), new float[]{0.0f, 0.18f, 0.32f, 0.66f, 0.89f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.99607843f, 0.99607843f, 0.99215686f, 1.0f), new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    graphics2D.fill(area5);
                    GeneralPath generalPath6 = new GeneralPath();
                    generalPath6.setWindingRule(0);
                    generalPath6.moveTo(0.9299065420560748 * (double)n2, 0.9299065420560748 * (double)n3);
                    generalPath6.curveTo(0.9299065420560748 * (double)n2, 0.9299065420560748 * (double)n3, 0.9299065420560748 * (double)n2, 0.06542056074766354 * (double)n3, 0.9299065420560748 * (double)n2, 0.06542056074766354 * (double)n3);
                    generalPath6.curveTo(0.40654205607476634 * (double)n2, 0.06542056074766354 * (double)n3, 0.07009345794392523 * (double)n2, 0.37383177570093457 * (double)n3, 0.07009345794392523 * (double)n2, 0.9299065420560748 * (double)n3);
                    generalPath6.curveTo(0.07009345794392523 * (double)n2, 0.9299065420560748 * (double)n3, 0.9299065420560748 * (double)n2, 0.9299065420560748 * (double)n3, 0.9299065420560748 * (double)n2, 0.9299065420560748 * (double)n3);
                    generalPath6.closePath();
                    Area area6 = new Area(generalPath6);
                    area6.subtract(area);
                    graphics2D.setPaint(new Color(0.9647059f, 0.9647059f, 0.9647059f, 1.0f));
                    graphics2D.fill(area6);
                    GeneralPath generalPath7 = new GeneralPath();
                    generalPath7.setWindingRule(0);
                    generalPath7.moveTo(0.9252336448598131 * (double)n2, 0.9252336448598131 * (double)n3);
                    generalPath7.curveTo(0.9252336448598131 * (double)n2, 0.9252336448598131 * (double)n3, 0.9252336448598131 * (double)n2, 0.07009345794392523 * (double)n3, 0.9252336448598131 * (double)n2, 0.07009345794392523 * (double)n3);
                    generalPath7.curveTo(0.3878504672897196 * (double)n2, 0.07009345794392523 * (double)n3, 0.07476635514018691 * (double)n2, 0.4158878504672897 * (double)n3, 0.07476635514018691 * (double)n2, 0.9252336448598131 * (double)n3);
                    generalPath7.curveTo(0.07476635514018691 * (double)n2, 0.9252336448598131 * (double)n3, 0.9252336448598131 * (double)n2, 0.9252336448598131 * (double)n3, 0.9252336448598131 * (double)n2, 0.9252336448598131 * (double)n3);
                    generalPath7.closePath();
                    Area area7 = new Area(generalPath7);
                    area7.subtract(area);
                    graphics2D.setPaint(new Color(0.2f, 0.2f, 0.2f, 1.0f));
                    graphics2D.fill(area7);
                    break;
                }
                case BRASS: {
                    float[] fArray3 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray3 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray3, colorArray3);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case STEEL: {
                    float[] fArray4 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray4 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray4, colorArray4);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case CHROME: {
                    float[] fArray5 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] colorArray5 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_3, 0.0f, fArray5, colorArray5);
                    graphics2D.setPaint(conicalGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case GOLD: {
                    float[] fArray6 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] colorArray6 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray6, colorArray6);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case ANTHRACITE: {
                    float[] fArray7 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] colorArray7 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray7, colorArray7);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)double_2).setLocation(0.2336448598130841 * (double)n2, 0.08411214953271028 * (double)n3);
                    ((Point2D)double_).setLocation(0.8125818236066633 * (double)n2, 0.9109198204038422 * (double)n3);
                    float[] fArray8 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] colorArray8 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray8, colorArray8);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)double_2).setLocation(0.22897196261682243 * (double)n2, 0.0794392523364486 * (double)n3);
                    ((Point2D)double_).setLocation(0.8025483989678684 * (double)n2, 0.8985912966254403 * (double)n3);
                    float[] fArray9 = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] colorArray9 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray9, colorArray9);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                default: {
                    float[] fArray10 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] colorArray10 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray10, colorArray10);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                }
            }
        }
        float f2 = 1.0f;
        objectArray = new Shape[100];
        switch (this.getFrameEffect()) {
            case EFFECT_BULGE: {
                int n4;
                fArray = new float[]{0.0f, 0.13f, 0.14f, 0.17f, 0.18f, 1.0f};
                colorArray2 = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(0, 0, 0, 95), new Color(0, 0, 0, 76), new Color(0, 0, 0, 0)};
                paint2 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), fArray, colorArray2);
                for (n4 = 0; n4 < 100; ++n4) {
                    objectArray[n4] = Scaler.INSTANCE.scale(area3, f2);
                    f2 -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    graphics2D.setPaint(paint2.getColorAt((float)n4 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n4]);
                }
                break;
            }
            case EFFECT_CONE: {
                int n5;
                fArray = new float[]{0.0f, 0.0399f, 0.04f, 0.1799f, 0.18f, 1.0f};
                colorArray2 = new Color[]{new Color(0, 0, 0, 76), new Color(223, 223, 223, 127), new Color(255, 255, 255, 124), new Color(9, 9, 9, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                paint2 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), fArray, colorArray2);
                for (n5 = 0; n5 < 100; ++n5) {
                    objectArray[n5] = Scaler.INSTANCE.scale(area3, f2);
                    f2 -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    graphics2D.setPaint(paint2.getColorAt((float)n5 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n5]);
                }
                break;
            }
            case EFFECT_TORUS: {
                int n6;
                fArray = new float[]{0.0f, 0.08f, 0.1799f, 0.18f, 1.0f};
                colorArray2 = new Color[]{new Color(0, 0, 0, 76), new Color(255, 255, 255, 64), new Color(13, 13, 13, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                paint2 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), fArray, colorArray2);
                for (n6 = 0; n6 < 100; ++n6) {
                    objectArray[n6] = Scaler.INSTANCE.scale(area3, f2);
                    f2 -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n6 = 0; n6 < objectArray.length; ++n6) {
                    graphics2D.setPaint(paint2.getColorAt((float)n6 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n6]);
                }
                break;
            }
            case EFFECT_INNER_FRAME: {
                object2 = Scaler.INSTANCE.scale(area3, 0.8785046339035034);
                object = new Point2D.Double(0.0, object2.getBounds2D().getMinY());
                colorArray = new Point2D.Double(0.0, object2.getBounds2D().getMaxY());
                fArray = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                colorArray2 = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                paint = new LinearGradientPaint((Point2D)object, (Point2D)colorArray, fArray, colorArray2);
                graphics2D.setPaint(paint);
                graphics2D.fill((Shape)object2);
            }
        }
        object2 = new GeneralPath();
        ((Path2D)object2).setWindingRule(0);
        ((Path2D.Float)object2).moveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.9205607476635514);
        ((Path2D.Float)object2).curveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.9205607476635514, (double)n2 * 0.9205607476635514, (double)n3 * 0.0794392523364486, (double)n2 * 0.9205607476635514, (double)n3 * 0.0794392523364486);
        ((Path2D.Float)object2).curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.0794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.13551401869158877, (double)n2 * 0.3037383177570093, (double)n3 * 0.308411214953271);
        ((Path2D.Float)object2).curveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.4439252336448598, (double)n2 * 0.0794392523364486, (double)n3 * 0.6822429906542056, (double)n2 * 0.0794392523364486, (double)n3 * 0.9205607476635514);
        ((Path2D.Float)object2).curveTo((double)n2 * 0.0794392523364486, (double)n3 * 0.9205607476635514, (double)n2 * 0.9205607476635514, (double)n3 * 0.9205607476635514, (double)n2 * 0.9205607476635514, (double)n3 * 0.9205607476635514);
        ((Path2D)object2).closePath();
        graphics2D.setColor(Color.WHITE);
        object = new Area((Shape)object2);
        ((Area)object).subtract(area);
        graphics2D.fill((Shape)object);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_BACKGROUND_Image(int n, BufferedImage bufferedImage) {
        Object object;
        Color[] colorArray;
        Object object2;
        Object object3;
        Point2D.Double double_;
        Point2D.Double double_2;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        boolean bl = false;
        AffineTransform affineTransform = graphics2D.getTransform();
        this.transformGraphics(n2, n3, graphics2D);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028);
        generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.08411214953271028, (double)n2 * 0.46261682242990654, (double)n3 * 0.1588785046728972, (double)n2 * 0.29439252336448596, (double)n3 * 0.32242990654205606);
        generalPath.curveTo((double)n2 * 0.17289719626168223, (double)n3 * 0.4439252336448598, (double)n2 * 0.08411214953271028, (double)n3 * 0.6635514018691588, (double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.closePath();
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                break;
            }
            case NORTH_EAST: {
                double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                break;
            }
            case SOUTH_EAST: {
                double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                break;
            }
            default: {
                double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            }
        }
        float[] fArray = new float[]{0.0f, 0.39f, 1.0f};
        Paint paint = null;
        if (this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM) {
            graphics2D.setPaint(this.getCustomBackground());
        } else {
            object3 = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
            if (this.getBackgroundColor() == BackgroundColor.BRUSHED_METAL) {
                paint = new TexturePaint(UTIL.createBrushMetalTexture(this.getModel().getTextureColor(), generalPath.getBounds().width, generalPath.getBounds().height), generalPath.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS) {
                object2 = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                colorArray = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                paint = new ConicalGradientPaint(false, this.ROTATION_CENTER, -0.45f, (float[])object2, colorArray);
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS_GRINDED) {
                paint = new TexturePaint(Radial1Square.BACKGROUND_FACTORY.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (this.getBackgroundColor() == BackgroundColor.CARBON) {
                paint = new TexturePaint(Radial1Square.BACKGROUND_FACTORY.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (this.getBackgroundColor() == BackgroundColor.PUNCHED_SHEET) {
                paint = new TexturePaint(BACKGROUND_FACTORY.getPunchedSheetTexture(), new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (this.getBackgroundColor() == BackgroundColor.LINEN) {
                paint = new TexturePaint(UTIL.createLinenTexture(this.getModel().getTextureColor(), generalPath.getBounds().width, generalPath.getBounds().height), generalPath.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMinY());
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMaxY());
                if (double_2.equals(double_)) {
                    ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
                }
                object2 = new float[]{0.0f, 1.0f};
                colorArray = new Color[]{UTIL.lighter(this.getTextureColor(), 0.15f), UTIL.darker(this.getTextureColor(), 0.15f)};
                paint = new LinearGradientPaint(double_2, double_, (float[])object2, colorArray);
            } else {
                paint = new LinearGradientPaint(double_2, double_, fArray, (Color[])object3);
            }
            graphics2D.setPaint(paint);
        }
        graphics2D.fill(generalPath);
        object3 = this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(generalPath, this.getCustomBackground(), 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(generalPath, paint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)object3, generalPath.getBounds().x, generalPath.getBounds().y, null);
        if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
            object2 = new Random();
            colorArray = new Random();
            object = graphics2D.getClip();
            graphics2D.setClip(generalPath);
            int n4 = 0;
            while ((double)n4 < generalPath.getBounds().getHeight()) {
                int n5 = 0;
                while ((double)n5 < generalPath.getBounds().getWidth()) {
                    Color color = ((Random)object2).nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int n6 = 10 + colorArray.nextInt(10) - 5;
                    graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n6));
                    graphics2D.drawLine((int)((double)n5 + generalPath.getBounds2D().getMinX()), (int)((double)n4 + generalPath.getBounds2D().getMinY()), (int)((double)n5 + generalPath.getBounds2D().getMinX()), (int)((double)n4 + generalPath.getBounds2D().getMinY()));
                    ++n5;
                }
                ++n4;
            }
            graphics2D.setClip((Shape)object);
        }
        if (bl) {
            object2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            object = new LinearGradientPaint(new Point2D.Double(generalPath.getBounds().getMinX(), 0.0), new Point2D.Double(generalPath.getBounds().getMaxX(), 0.0), (float[])object2, colorArray);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(generalPath);
        }
        if (this.isCustomLayerVisible()) {
            graphics2D.setTransform(affineTransform);
            graphics2D.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), n2, n3, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int n, PointerType pointerType) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        switch (pointerType) {
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.6635514018691588, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.6682242990654206, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
                generalPath.curveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                GeneralPath generalPath = new GeneralPath(new Rectangle2D.Double((double)n2 * 0.16355140186915887, (double)n3 * 0.822429906542056, (double)n2 * 0.6775700935, (double)n3 * 0.009345794392523364));
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().LIGHT);
                }
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.8037383177570093);
                generalPath.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.8504672897196262);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_3 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.16822429906542055, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8551401869158879);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_4 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.45f, 0.46f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_4, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8457943925233645);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.8457943925233645);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.6448598130841121, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8457943925233645);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxX());
                Point2D.Double double_5 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinX());
                float[] fArray = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_5, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8504672897196262);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_6 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_6, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486, (double)n2 * 0.7850467289719626, (double)n3 * 0.8177570093457944, (double)n2 * 0.16822429906542055, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.lineTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_7 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_7, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.29439252336448596, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.7663551401869159, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.7663551401869159, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.8317757009345794);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8551401869158879);
                generalPath.lineTo((double)n2 * 0.8551401869158879, (double)n3 * 0.8551401869158879);
                generalPath.curveTo((double)n2 * 0.8551401869158879, (double)n3 * 0.8551401869158879, (double)n2 * 0.8878504672897196, (double)n3 * 0.8504672897196262, (double)n2 * 0.8878504672897196, (double)n3 * 0.8504672897196262);
                generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8504672897196262, (double)n2 * 0.8925233644859814, (double)n3 * 0.8457943925233645, (double)n2 * 0.8925233644859814, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8084112149532711, (double)n2 * 0.8925233644859814, (double)n3 * 0.8037383177570093, (double)n2 * 0.8878504672897196, (double)n3 * 0.8037383177570093);
                generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.8037383177570093, (double)n2 * 0.8551401869158879, (double)n3 * 0.7990654205607477, (double)n2 * 0.8551401869158879, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8177570093457944);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_8 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.48f, 1.0f};
                Color[] colorArray = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_8, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(new Color(0x2E2E2E));
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.2523364485981308, (double)n3 * 0.8317757009345794);
                generalPath2.lineTo((double)n2 * 0.2523364485981308, (double)n3 * 0.822429906542056);
                generalPath2.lineTo((double)n2 * 0.16822429906542055, (double)n3 * 0.822429906542056);
                generalPath2.lineTo((double)n2 * 0.16822429906542055, (double)n3 * 0.8317757009345794);
                generalPath2.lineTo((double)n2 * 0.2523364485981308, (double)n3 * 0.8317757009345794);
                generalPath2.closePath();
                graphics2D.setColor(this.getPointerColor().MEDIUM);
                graphics2D.fill(generalPath2);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.822429906542056, (double)n3 * 0.883177570093458, (double)n2 * 0.8317757009345794, (double)n3 * 0.883177570093458);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.883177570093458, (double)n2 * 0.8878504672897196, (double)n3 * 0.8598130841121495, (double)n2 * 0.8878504672897196, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.7990654205607477, (double)n2 * 0.8598130841121495, (double)n3 * 0.7710280373831776, (double)n2 * 0.8317757009345794, (double)n3 * 0.7710280373831776);
                generalPath.curveTo((double)n2 * 0.822429906542056, (double)n3 * 0.7710280373831776, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_9 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_9, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(this.getPointerColor().MEDIUM);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.curveTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3, 0.9018691588785047 * (double)n2, 0.8411214953271028 * (double)n3, 0.9018691588785047 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.curveTo(0.9018691588785047 * (double)n2, 0.8130841121495327 * (double)n3, 0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3, 0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.16822429906542055 * (double)n2, 0.822429906542056 * (double)n3), new Point2D.Double(0.897196261682243 * (double)n2, 0.822429906542056 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                graphics2D.fill(generalPath);
                graphics2D.setPaint(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(0.004672897f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.8411214953271028 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.16822429906542055 * (double)n2, 0.822429906542056 * (double)n3), new Point2D.Double(0.8364485981308412 * (double)n2, 0.822429906542056 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                graphics2D.fill(generalPath);
                graphics2D.setPaint(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(0.004672897f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.16355140186915887 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.822429906542056 * (double)n2, 0.8271028037383178 * (double)n3), new Point2D.Double(0.16822429906542055 * (double)n2, 0.8271028037383179 * (double)n3), new float[]{0.0f, 0.899999f, 0.9f, 1.0f}, new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR}));
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.16355140186915887 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.7476635514018691 * (double)n2, 0.8411214953271028 * (double)n3), new Point2D.Double(0.7476635514018691 * (double)n2, 0.8084112149532711 * (double)n3), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{this.getPointerColor().VERY_DARK, this.getPointerColor().LIGHT, this.getPointerColor().VERY_DARK}));
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8130841121495327, (double)n2 * 0.7429906542056075, (double)n3 * 0.8130841121495327, (double)n2 * 0.7289719626168224, (double)n3 * 0.8130841121495327);
                generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.822429906542056, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.7149532710280374, (double)n3 * 0.8364485981308412, (double)n2 * 0.7242990654205608, (double)n3 * 0.8411214953271028);
                generalPath.curveTo((double)n2 * 0.7429906542056075, (double)n3 * 0.8411214953271028, (double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
                generalPath.curveTo((double)n2 * 0.8084112149532711, (double)n3 * 0.8551401869158879, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.8084112149532711, (double)n3 * 0.7990654205607477, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_10 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().DARK};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_10, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                Color color = this.getPointerColor().LIGHT;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int n, PointerType pointerType) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        switch (pointerType) {
            case TYPE1: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8130841121495327, (double)n2 * 0.7429906542056075, (double)n3 * 0.8130841121495327, (double)n2 * 0.7289719626168224, (double)n3 * 0.8130841121495327);
                generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.822429906542056, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.7149532710280374, (double)n3 * 0.8364485981308412, (double)n2 * 0.7242990654205608, (double)n3 * 0.8411214953271028);
                generalPath.curveTo((double)n2 * 0.7429906542056075, (double)n3 * 0.8411214953271028, (double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
                generalPath.curveTo((double)n2 * 0.8084112149532711, (double)n3 * 0.8551401869158879, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.8084112149532711, (double)n3 * 0.7990654205607477, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.6635514018691588, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.2102803738317757, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.6682242990654206, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
                generalPath.curveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.8037383177570093);
                generalPath.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.8504672897196262);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.16822429906542055, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8551401869158879);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8457943925233645);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.8457943925233645);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.6448598130841121, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8457943925233645);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8504672897196262);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.8084112149532711);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.lineTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
                generalPath.curveTo((double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486, (double)n2 * 0.7850467289719626, (double)n3 * 0.8177570093457944, (double)n2 * 0.16822429906542055, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
                generalPath.lineTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.29439252336448596, (double)n3 * 0.8317757009345794);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.822429906542056);
                generalPath.lineTo((double)n2 * 0.7663551401869159, (double)n3 * 0.8130841121495327);
                generalPath.lineTo((double)n2 * 0.7663551401869159, (double)n3 * 0.8411214953271028);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.8317757009345794);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8551401869158879);
                generalPath.lineTo((double)n2 * 0.8551401869158879, (double)n3 * 0.8551401869158879);
                generalPath.curveTo((double)n2 * 0.8551401869158879, (double)n3 * 0.8551401869158879, (double)n2 * 0.8878504672897196, (double)n3 * 0.8504672897196262, (double)n2 * 0.8878504672897196, (double)n3 * 0.8504672897196262);
                generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8504672897196262, (double)n2 * 0.8925233644859814, (double)n3 * 0.8457943925233645, (double)n2 * 0.8925233644859814, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8084112149532711, (double)n2 * 0.8925233644859814, (double)n3 * 0.8037383177570093, (double)n2 * 0.8878504672897196, (double)n3 * 0.8037383177570093);
                generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.8037383177570093, (double)n2 * 0.8551401869158879, (double)n3 * 0.7990654205607477, (double)n2 * 0.8551401869158879, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.7990654205607477);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8177570093457944);
                generalPath.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8364485981308412);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.822429906542056, (double)n3 * 0.883177570093458, (double)n2 * 0.8317757009345794, (double)n3 * 0.883177570093458);
                generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.883177570093458, (double)n2 * 0.8878504672897196, (double)n3 * 0.8598130841121495, (double)n2 * 0.8878504672897196, (double)n3 * 0.8271028037383178);
                generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.7990654205607477, (double)n2 * 0.8598130841121495, (double)n3 * 0.7710280373831776, (double)n2 * 0.8317757009345794, (double)n3 * 0.7710280373831776);
                generalPath.curveTo((double)n2 * 0.822429906542056, (double)n3 * 0.7710280373831776, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178, (double)n2 * 0.16355140186915887, (double)n3 * 0.8271028037383178);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.curveTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3, 0.9018691588785047 * (double)n2, 0.8411214953271028 * (double)n3, 0.9018691588785047 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.curveTo(0.9018691588785047 * (double)n2, 0.8130841121495327 * (double)n3, 0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3, 0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.8411214953271028 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.16822429906542055 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.16355140186915887 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.16355140186915887 * (double)n2, 0.8271028037383178 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8130841121495327 * (double)n3);
                generalPath.lineTo(0.8317757009345794 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.lineTo(0.20093457943925233 * (double)n2, 0.8411214953271028 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POSTS_Image(int n, BufferedImage bufferedImage) {
        LinearGradientPaint linearGradientPaint;
        Color[] colorArray;
        float[] fArray;
        Point2D.Double double_;
        Point2D.Double double_2;
        Ellipse2D.Double double_3;
        LinearGradientPaint linearGradientPaint2;
        Color[] colorArray2;
        float[] fArray2;
        Point2D.Double double_4;
        Point2D.Double double_5;
        Ellipse2D.Double double_6;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        if (this.getPostsVisible()) {
            if (this.getOrientation() == Orientation.NORTH_EAST || this.getOrientation() == Orientation.NORTH_WEST) {
                double_6 = new Ellipse2D.Double((double)n2 * (double)0.1588785f, (double)n3 * 0.836448609828949, (double)n2 * 0.03738318383693695, (double)n3 * 0.03738313913345337);
                double_5 = new Point2D.Double(0.0, double_6.getBounds2D().getMinY());
                double_4 = new Point2D.Double(0.0, double_6.getBounds2D().getMaxY());
                fArray2 = new float[]{0.0f, 0.46f, 1.0f};
                colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                linearGradientPaint2 = new LinearGradientPaint(double_5, double_4, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(double_6);
                double_3 = new Ellipse2D.Double((double)n2 * (double)0.1635514f, (double)n3 * 0.84112149477005, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
                double_2 = new Point2D.Double(0.0, double_3.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, double_3.getBounds2D().getMaxY());
                fArray = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_3);
            }
            if (this.getOrientation() == Orientation.SOUTH_EAST || this.getOrientation() == Orientation.SOUTH_WEST) {
                double_6 = new Ellipse2D.Double((double)n2 * 0.8317757248878479, (double)n3 * 0.1682243049144745, (double)n2 * 0.03738313913345337, (double)n3 * 0.03738316893577576);
                double_5 = new Point2D.Double(double_6.getBounds2D().getMaxX(), 0.0);
                double_4 = new Point2D.Double(double_6.getBounds2D().getMinX(), 0.0);
                fArray2 = new float[]{0.0f, 0.46f, 1.0f};
                colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                linearGradientPaint2 = new LinearGradientPaint(double_5, double_4, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(double_6);
                double_3 = new Ellipse2D.Double((double)n2 * 0.836448609828949, (double)n3 * 0.17289718985557556, (double)n2 * 0.02803736925125122, (double)n3 * 0.028037384152412415);
                double_2 = new Point2D.Double(double_3.getBounds2D().getMaxX(), 0.0);
                double_ = new Point2D.Double(double_3.getBounds2D().getMinX(), 0.0);
                fArray = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_3);
            }
        }
        switch (this.getKnobType()) {
            case SMALL_STD_KNOB: {
                double_6 = new Ellipse2D.Double((double)n2 * 0.7850467562675476, (double)n3 * 0.7850467562675476, (double)n2 * 0.08411210775375366, (double)n3 * 0.08411210775375366);
                double_5 = new Point2D.Double(0.0, double_6.getBounds2D().getMinY());
                double_4 = new Point2D.Double(0.0, double_6.getBounds2D().getMaxY());
                fArray2 = new float[]{0.0f, 0.46f, 1.0f};
                colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                linearGradientPaint2 = new LinearGradientPaint(double_5, double_4, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(double_6);
                double_3 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7943925261497498, (double)n2 * 0.06542056798934937, (double)n3 * 0.06542056798934937);
                double_2 = new Point2D.Double(0.0, double_3.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, double_3.getBounds2D().getMaxY());
                fArray = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_3);
                Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7943925261497498, (double)n2 * 0.06542056798934937, (double)n3 * 0.06542056798934937);
                Point2D.Double double_8 = new Point2D.Double(0.822429906542056 * (double)n2, 0.8177570093457944 * (double)n3);
                float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(0.03271028037383177 * (double)n2), fArray3, colorArray3);
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_7);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] colorArray4;
                Color[] colorArray5;
                Color[] colorArray6;
                Color[] colorArray7;
                Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.7663551568984985, (double)n3 * 0.7663551568984985, (double)n2 * 0.1214953064918518, (double)n3 * 0.1214953064918518);
                Point2D.Double double_10 = new Point2D.Double(0.0, double_9.getBounds2D().getMinY());
                Point2D.Double double_11 = new Point2D.Double(0.0, double_9.getBounds2D().getMaxY());
                float[] fArray4 = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray7 = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray7 = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        colorArray7 = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_10, double_11, fArray4, colorArray7);
                graphics2D.setPaint(linearGradientPaint3);
                graphics2D.fill(double_9);
                Ellipse2D.Double double_12 = new Ellipse2D.Double((double)n2 * 0.7710280418395996, (double)n3 * 0.7710280418395996, (double)n2 * 0.11214953660964966, (double)n3 * 0.11214953660964966);
                Point2D.Double double_13 = new Point2D.Double(0.0, double_12.getBounds2D().getMinY());
                Point2D.Double double_14 = new Point2D.Double(0.0, double_12.getBounds2D().getMaxY());
                float[] fArray5 = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray6 = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray6 = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        colorArray6 = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_13, double_14, fArray5, colorArray6);
                graphics2D.setPaint(linearGradientPaint4);
                graphics2D.fill(double_12);
                Ellipse2D.Double double_15 = new Ellipse2D.Double((double)n2 * 0.7803738117218018, (double)n3 * 0.7803738117218018, (double)n2 * 0.09345793724060059, (double)n3 * 0.09345793724060059);
                Point2D.Double double_16 = new Point2D.Double(0.0, double_15.getBounds2D().getMinY());
                Point2D.Double double_17 = new Point2D.Double(0.0, double_15.getBounds2D().getMaxY());
                float[] fArray6 = new float[]{0.0f, 0.47f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray5 = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray5 = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        colorArray5 = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint5 = new LinearGradientPaint(double_16, double_17, fArray6, colorArray5);
                graphics2D.setPaint(linearGradientPaint5);
                graphics2D.fill(double_15);
                Ellipse2D.Double double_18 = new Ellipse2D.Double((double)n2 * 0.7850467562675476, (double)n3 * 0.7850467562675476, (double)n2 * 0.08411210775375366, (double)n3 * 0.08411210775375366);
                Point2D.Double double_19 = new Point2D.Double(0.0, double_18.getBounds2D().getMinY());
                Point2D.Double double_20 = new Point2D.Double(0.0, double_18.getBounds2D().getMaxY());
                float[] fArray7 = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray4 = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray4 = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        colorArray4 = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint6 = new LinearGradientPaint(double_19, double_20, fArray7, colorArray4);
                graphics2D.setPaint(linearGradientPaint6);
                graphics2D.fill(double_18);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double double_21 = new Ellipse2D.Double((double)n2 * 0.7570093274116516, (double)n3 * 0.7570093274116516, (double)n2 * (double)0.1401869f, (double)n3 * (double)0.1401869f);
                Point2D.Double double_22 = new Point2D.Double(0.7897196261682243 * (double)n2, 0.7663551401869159 * (double)n3);
                Point2D.Double double_23 = new Point2D.Double(0.8615311152465558 * (double)n2, 0.8812775457408241 * (double)n3);
                float[] fArray8 = new float[]{0.0f, 1.0f};
                Color[] colorArray8 = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint linearGradientPaint7 = new LinearGradientPaint(double_22, double_23, fArray8, colorArray8);
                graphics2D.setPaint(linearGradientPaint7);
                graphics2D.fill(double_21);
                Ellipse2D.Double double_24 = new Ellipse2D.Double((double)n2 * 0.7616822719573975, (double)n3 * 0.7616822719573975, (double)n2 * 0.13084107637405396, (double)n3 * 0.13084107637405396);
                Point2D.Double double_25 = new Point2D.Double(double_24.getCenterX(), double_24.getCenterY());
                float[] fArray9 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] colorArray9 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_25, 0.0f, fArray9, colorArray9);
                graphics2D.setPaint(conicalGradientPaint);
                graphics2D.fill(double_24);
                Ellipse2D.Double double_26 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7943925261497498, (double)n2 * 0.06542056798934937, (double)n3 * 0.06542056798934937);
                Point2D.Double double_27 = new Point2D.Double(0.8084112149532711 * (double)n2, 0.7990654205607477 * (double)n3);
                Point2D.Double double_28 = new Point2D.Double(0.8423808773136435 * (double)n2, 0.8494275160897923 * (double)n3);
                float[] fArray10 = new float[]{0.0f, 1.0f};
                Color[] colorArray10 = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint linearGradientPaint8 = new LinearGradientPaint(double_27, double_28, fArray10, colorArray10);
                graphics2D.setPaint(linearGradientPaint8);
                graphics2D.fill(double_26);
                Ellipse2D.Double double_29 = new Ellipse2D.Double((double)n2 * 0.7990654110908508, (double)n3 * 0.7990654110908508, (double)n2 * 0.05607479810714722, (double)n3 * 0.05607479810714722);
                Point2D.Double double_30 = new Point2D.Double(0.8084112149532711 * (double)n2, 0.8037383177570093 * (double)n3);
                Point2D.Double double_31 = new Point2D.Double(0.8397678263628456 * (double)n2, 0.8502264059376659 * (double)n3);
                float[] fArray11 = new float[]{0.0f, 1.0f};
                Color[] colorArray11 = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint linearGradientPaint9 = new LinearGradientPaint(double_30, double_31, fArray11, colorArray11);
                graphics2D.setPaint(linearGradientPaint9);
                graphics2D.fill(double_29);
                break;
            }
            case METAL_KNOB: {
                Color[] colorArray12;
                Ellipse2D.Double double_32 = new Ellipse2D.Double((double)n2 * 0.7897196412086487, (double)n3 * 0.7850467562675476, (double)n2 * 0.08411210775375366, (double)n3 * 0.08411210775375366);
                Point2D.Double double_33 = new Point2D.Double(0.0, double_32.getBounds2D().getMinY());
                Point2D.Double double_34 = new Point2D.Double(0.0, double_32.getBounds2D().getMaxY());
                float[] fArray12 = new float[]{0.0f, 0.47f, 1.0f};
                Color[] colorArray13 = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint linearGradientPaint10 = new LinearGradientPaint(double_33, double_34, fArray12, colorArray13);
                graphics2D.setPaint(linearGradientPaint10);
                graphics2D.fill(double_32);
                Ellipse2D.Double double_35 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7897196412086487, (double)n2 * 0.07476633787155151, (double)n3 * 0.07476633787155151);
                Point2D.Double double_36 = new Point2D.Double(0.0, double_35.getBounds2D().getMinY());
                Point2D.Double double_37 = new Point2D.Double(0.0, double_35.getBounds2D().getMaxY());
                float[] fArray13 = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray12 = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        colorArray12 = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        colorArray12 = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint11 = new LinearGradientPaint(double_36, double_37, fArray13, colorArray12);
                graphics2D.setPaint(linearGradientPaint11);
                graphics2D.fill(double_35);
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.8504672897196262, (double)n3 * 0.8551401869158879);
                generalPath.curveTo((double)n2 * 0.8504672897196262, (double)n3 * 0.8457943925233645, (double)n2 * 0.8411214953271028, (double)n3 * 0.8411214953271028, (double)n2 * 0.8317757009345794, (double)n3 * 0.8411214953271028);
                generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.8411214953271028, (double)n2 * 0.8084112149532711, (double)n3 * 0.8457943925233645, (double)n2 * 0.8084112149532711, (double)n3 * 0.8551401869158879);
                generalPath.curveTo((double)n2 * 0.8130841121495327, (double)n3 * 0.8598130841121495, (double)n2 * 0.822429906542056, (double)n3 * 0.8644859813084113, (double)n2 * 0.8317757009345794, (double)n3 * 0.8644859813084113);
                generalPath.curveTo((double)n2 * 0.8364485981308412, (double)n3 * 0.8644859813084113, (double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8504672897196262, (double)n3 * 0.8551401869158879);
                generalPath.closePath();
                Point2D.Double double_38 = new Point2D.Double(0.8317757009345794 * (double)n2, 0.8644859813084113 * (double)n3);
                float[] fArray14 = new float[]{0.0f, 1.0f};
                Color[] colorArray14 = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_38, (float)(0.03271028037383177 * (double)n2), fArray14, colorArray14);
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.8644859813084113, (double)n3 * 0.8084112149532711);
                generalPath2.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.794392523364486, (double)n2 * 0.8457943925233645, (double)n3 * 0.7850467289719626, (double)n2 * 0.8317757009345794, (double)n3 * 0.7850467289719626);
                generalPath2.curveTo((double)n2 * 0.8130841121495327, (double)n3 * 0.7850467289719626, (double)n2 * 0.7990654205607477, (double)n3 * 0.794392523364486, (double)n2 * 0.794392523364486, (double)n3 * 0.8084112149532711);
                generalPath2.curveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327, (double)n2 * 0.8130841121495327, (double)n3 * 0.8177570093457944, (double)n2 * 0.8317757009345794, (double)n3 * 0.8177570093457944);
                generalPath2.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8177570093457944, (double)n2 * 0.8598130841121495, (double)n3 * 0.8130841121495327, (double)n2 * 0.8644859813084113, (double)n3 * 0.8084112149532711);
                generalPath2.closePath();
                Point2D.Double double_39 = new Point2D.Double(0.8271028037383178 * (double)n2, 0.7850467289719626 * (double)n3);
                float[] fArray15 = new float[]{0.0f, 1.0f};
                Color[] colorArray15 = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_39, (float)(0.04906542056074766 * (double)n2), fArray15, colorArray15);
                graphics2D.setPaint(radialGradientPaint2);
                graphics2D.fill(generalPath2);
                Ellipse2D.Double double_40 = new Ellipse2D.Double((double)n2 * 0.8084112405776978, (double)n3 * 0.8084112405776978, (double)n2 * 0.04205602407455444, (double)n3 * 0.04205602407455444);
                Point2D.Double double_41 = new Point2D.Double(0.0, double_40.getBounds2D().getMinY());
                Point2D.Double double_42 = new Point2D.Double(0.0, double_40.getBounds2D().getMaxY());
                float[] fArray16 = new float[]{0.0f, 1.0f};
                Color[] colorArray16 = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint linearGradientPaint12 = new LinearGradientPaint(double_41, double_42, fArray16, colorArray16);
                graphics2D.setPaint(linearGradientPaint12);
                graphics2D.fill(double_40);
                Ellipse2D.Double double_43 = new Ellipse2D.Double((double)n2 * 0.8130841255187988, (double)n3 * 0.8130841255187988, (double)n2 * 0.032710254192352295, (double)n3 * 0.032710254192352295);
                Point2D.Double double_44 = new Point2D.Double(0.0, double_43.getBounds2D().getMinY());
                Point2D.Double double_45 = new Point2D.Double(0.0, double_43.getBounds2D().getMaxY());
                float[] fArray17 = new float[]{0.0f, 1.0f};
                Color[] colorArray17 = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint linearGradientPaint13 = new LinearGradientPaint(double_44, double_45, fArray17, colorArray17);
                graphics2D.setPaint(linearGradientPaint13);
                graphics2D.fill(double_43);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_FOREGROUND_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        if (this.getOrientation() == Orientation.NORTH_EAST || this.getOrientation() == Orientation.NORTH_WEST) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.setWindingRule(0);
            generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.3925233644859813);
            generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.35514018691588783, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028);
            generalPath.curveTo((double)n2 * 0.7710280373831776, (double)n3 * 0.08411214953271028, (double)n2 * 0.5887850467289719, (double)n3 * 0.102803738317757, (double)n2 * 0.4392523364485981, (double)n3 * 0.205607476635514);
            generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.29439252336448596, (double)n2 * 0.22429906542056074, (double)n3 * 0.37850467289719625, (double)n2 * 0.1542056074766355, (double)n3 * 0.5420560747663551);
            generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.3691588785046729, (double)n2 * 0.794392523364486, (double)n3 * 0.38317757009345793, (double)n2 * 0.9158878504672897, (double)n3 * 0.3925233644859813);
            generalPath.closePath();
            Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
            Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.setWindingRule(0);
            generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
            generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.5560747663551402, (double)n2 * 0.9158878504672897, (double)n3 * 0.5560747663551402);
            generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.5327102803738317, (double)n2 * 0.22897196261682243, (double)n3 * 0.6308411214953271, (double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897);
            generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
            generalPath.closePath();
            Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            Point2D.Double double_3 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_GLOW_Image(int n, Color color, boolean bl) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8925233644859814);
        generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.8925233644859814, (double)n2 * 0.10747663551401869, (double)n3 * 0.8925233644859814, (double)n2 * 0.10747663551401869, (double)n3 * 0.8925233644859814);
        generalPath.curveTo((double)n2 * 0.10747663551401869, (double)n3 * 0.6588785046728972, (double)n2 * 0.19626168224299065, (double)n3 * 0.4532710280373832, (double)n2 * 0.308411214953271, (double)n3 * 0.3411214953271028);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.17757009345794392, (double)n2 * 0.6308411214953271, (double)n3 * 0.10747663551401869, (double)n2 * 0.8925233644859814, (double)n3 * 0.10747663551401869);
        generalPath.curveTo((double)n2 * 0.8925233644859814, (double)n3 * 0.10747663551401869, (double)n2 * 0.8925233644859814, (double)n3 * 0.8925233644859814, (double)n2 * 0.8925233644859814, (double)n3 * 0.8925233644859814);
        generalPath.closePath();
        generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028);
        generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.08411214953271028, (double)n2 * 0.46261682242990654, (double)n3 * 0.1588785046728972, (double)n2 * 0.29439252336448596, (double)n3 * 0.32242990654205606);
        generalPath.curveTo((double)n2 * 0.17289719626168223, (double)n3 * 0.4439252336448598, (double)n2 * 0.08411214953271028, (double)n3 * 0.6635514018691588, (double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.closePath();
        if (!bl) {
            Point2D.Double double_ = new Point2D.Double(0.3037383177570093 * (double)n2, 0.3037383177570093 * (double)n3);
            Point2D.Double double_2 = new Point2D.Double(0.901805268199837 * (double)n2, 0.9018052681998369 * (double)n3);
            float[] fArray = new float[]{0.0f, 0.19f, 0.2f, 0.39f, 0.4f, 0.64f, 0.65f, 0.82f, 1.0f};
            Color[] colorArray = new Color[]{new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(250, 250, 250, 102), new Color(158, 158, 158, 102), new Color(153, 153, 153, 102), new Color(202, 202, 202, 102), new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(153, 153, 153, 102)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        } else {
            graphics2D.translate(-10, -10);
            graphics2D.drawImage((Image)Shadow.INSTANCE.createDropShadow(generalPath, color, color, true, null, null, 0, 1.0f, 10, 315, color), generalPath.getBounds().x, generalPath.getBounds().y, null);
            graphics2D.translate(10, 10);
            Point2D.Double double_ = new Point2D.Double(0.3037383177570093 * (double)n2, 0.3037383177570093 * (double)n3);
            Point2D.Double double_3 = new Point2D.Double(0.901805268199837 * (double)n2, 0.9018052681998369 * (double)n3);
            float[] fArray = new float[]{0.0f, 0.26f, 0.42f, 0.42009997f, 0.56f, 0.5601f, 0.96f, 0.9601f, 1.0f};
            Color[] colorArray = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 63), new Color(255, 255, 255, 102), new Color(255, 255, 255, 98), new Color(255, 255, 255, 3), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 102)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_DISABLED_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.transformGraphics(n2, n3, graphics2D);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028, (double)n2 * 0.9158878504672897, (double)n3 * 0.08411214953271028);
        generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.08411214953271028, (double)n2 * 0.46261682242990654, (double)n3 * 0.1588785046728972, (double)n2 * 0.29439252336448596, (double)n3 * 0.32242990654205606);
        generalPath.curveTo((double)n2 * 0.17289719626168223, (double)n3 * 0.4439252336448598, (double)n2 * 0.08411214953271028, (double)n3 * 0.6635514018691588, (double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897, (double)n2 * 0.9158878504672897, (double)n3 * 0.9158878504672897);
        generalPath.closePath();
        graphics2D.setColor(new Color(102, 102, 102, 178));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial1Square";
    }
}

