/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.surface;

import java.awt.Point;
import net.ericaro.surfaceplotter.surface.Projector;

public final class SurfaceVertex {
    private Point projection;
    private int project_index;
    private static int master_project_index = 0;
    public float x;
    public float y;
    public float z;

    public SurfaceVertex(float ix, float iy, float iz) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.project_index = master_project_index - 1;
    }

    public final boolean isInvalid() {
        return Float.isNaN(this.z);
    }

    public final Point projection(Projector projector) {
        if (this.project_index != master_project_index) {
            this.projection = projector.project(this.x, this.y, (this.z - projector.zmin) * projector.zfactor - 10.0f);
            this.project_index = master_project_index;
        }
        return this.projection;
    }

    public final void transform(Projector projector) {
        this.x /= projector.getXScaling();
        this.y /= projector.getYScaling();
        this.z = (projector.zmax - projector.zmin) * (this.z / projector.getZScaling() + 10.0f) / 20.0f + projector.zmin;
    }

    public static void invalidate() {
        ++master_project_index;
    }
}

