/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.ArcTangent2;
import org.nfunk.jep.function.Arg;
import org.nfunk.jep.function.Binomial;
import org.nfunk.jep.function.ComplexPFMC;
import org.nfunk.jep.function.Conjugate;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.If;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.Polar;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Power;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.SquareRoot;
import org.nfunk.jep.function.Str;
import org.nfunk.jep.function.Sum;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.DoubleNumberFactory;
import org.nfunk.jep.type.NumberFactory;

public class JEP {
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean allowAssignment;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    protected Parser parser;
    private Node topNode = null;
    protected EvaluatorVisitor ev;
    protected NumberFactory numberFactory;
    protected OperatorSet opSet;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.allowAssignment = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.opSet = new OperatorSet();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
    }

    public JEP(boolean bl, boolean bl2, boolean bl3, NumberFactory numberFactory) {
        this.traverse = bl;
        this.allowUndeclared = bl2;
        this.implicitMul = bl3;
        this.numberFactory = numberFactory == null ? new DoubleNumberFactory() : numberFactory;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    protected JEP(JEP jEP) {
        this.traverse = jEP.traverse;
        this.allowUndeclared = jEP.allowUndeclared;
        this.allowAssignment = jEP.allowAssignment;
        this.implicitMul = jEP.implicitMul;
        this.ev = jEP.ev;
        this.funTab = jEP.funTab;
        this.opSet = jEP.opSet;
        this.numberFactory = jEP.numberFactory;
        this.parser = jEP.parser;
        this.symTab = jEP.symTab;
        this.errorList = jEP.errorList;
    }

    public void initSymTab() {
        this.symTab = new SymbolTable(new VariableFactory());
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("atan2", new ArcTangent2());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("exp", new Exp());
        this.funTab.put("pow", new Power());
        this.funTab.put("sqrt", new SquareRoot());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("sum", new Sum());
        this.funTab.put("rand", new Random());
        this.funTab.put("if", new If());
        this.funTab.put("str", new Str());
        this.funTab.put("binom", new Binomial());
    }

    public void addStandardConstants() {
        this.symTab.addConstant("pi", new Double(Math.PI));
        this.symTab.addConstant("e", new Double(Math.E));
    }

    public void addComplex() {
        this.symTab.addConstant("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
        this.funTab.put("arg", new Arg());
        this.funTab.put("cmod", new Abs());
        this.funTab.put("complex", new ComplexPFMC());
        this.funTab.put("polar", new Polar());
        this.funTab.put("conj", new Conjugate());
    }

    public void addFunction(String string, PostfixMathCommandI postfixMathCommandI) {
        this.funTab.put(string, postfixMathCommandI);
    }

    public Double addVariable(String string, double d) {
        Double d2 = new Double(d);
        this.symTab.makeVarIfNeeded(string, d2);
        return d2;
    }

    public void addConstant(String string, Object object) {
        this.symTab.addConstant(string, object);
    }

    public Complex addVariable(String string, double d, double d2) {
        Complex complex = new Complex(d, d2);
        this.symTab.makeVarIfNeeded(string, complex);
        return complex;
    }

    public void addVariable(String string, Object object) {
        this.symTab.makeVarIfNeeded(string, object);
    }

    public Object removeVariable(String string) {
        return this.symTab.remove(string);
    }

    public Object getVarValue(String string) {
        return this.symTab.getVar(string).getValue();
    }

    public void setVarValue(String string, Object object) {
        this.symTab.setVarValue(string, object);
    }

    public Variable getVar(String string) {
        return this.symTab.getVar(string);
    }

    public Object removeFunction(String string) {
        return this.funTab.remove(string);
    }

    public void setTraverse(boolean bl) {
        this.traverse = bl;
    }

    public boolean getTraverse() {
        return this.traverse;
    }

    public void setImplicitMul(boolean bl) {
        this.implicitMul = bl;
    }

    public boolean getImplicitMul() {
        return this.implicitMul;
    }

    public void setAllowUndeclared(boolean bl) {
        this.allowUndeclared = bl;
    }

    public boolean getAllowUndeclared() {
        return this.allowUndeclared;
    }

    public void setAllowAssignment(boolean bl) {
        this.allowAssignment = bl;
    }

    public boolean getAllowAssignment() {
        return this.allowAssignment;
    }

    public void parseExpression(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(stringReader, this);
        }
        catch (Throwable throwable) {
            this.topNode = null;
            if (throwable instanceof ParseException) {
                this.errorList.addElement(((ParseException)throwable).getMessage());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor parserDumpVisitor = new ParserDumpVisitor();
            try {
                this.topNode.jjtAccept(parserDumpVisitor, null);
            }
            catch (ParseException parseException) {
                this.errorList.addElement(parseException.getMessage());
            }
        }
    }

    public Node parse(String string) throws ParseException {
        StringReader stringReader = new StringReader(string);
        this.errorList.removeAllElements();
        Node node = this.parser.parseStream(stringReader, this);
        if (this.hasError()) {
            throw new ParseException(this.getErrorInfo());
        }
        return node;
    }

    public Object evaluate(Node node) throws ParseException {
        return this.ev.getValue(node, this.symTab);
    }

    public double getValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return Double.NaN;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            if (complex.im() != 0.0) {
                return Double.NaN;
            }
            return complex.re();
        }
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.NaN;
    }

    public Complex getComplexValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Complex) {
            return (Complex)object;
        }
        if (object instanceof Number) {
            return new Complex(((Number)object).doubleValue(), 0.0);
        }
        return null;
    }

    public Object getValueAsObject() {
        Object object;
        if (this.topNode == null || this.hasError()) {
            return null;
        }
        try {
            object = this.ev.getValue(this.topNode, this.symTab);
        }
        catch (ParseException parseException) {
            this.errorList.addElement("Error during evaluation: " + parseException.getMessage());
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.errorList.addElement(runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
            return null;
        }
        return object;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String string = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                string = string + this.errorList.elementAt(i) + "\n";
            }
            return string;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public EvaluatorVisitor getEvaluatorVisitor() {
        return this.ev;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public OperatorSet getOperatorSet() {
        return this.opSet;
    }

    public Parser getParser() {
        return this.parser;
    }
}

